/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.client;

import java.io.Closeable;
import org.apache.amoro.client.ServiceInfo;
import org.apache.amoro.client.ThriftUtil;
import org.apache.amoro.shade.thrift.org.apache.thrift.TServiceClient;
import org.apache.amoro.shade.thrift.org.apache.thrift.transport.TTransport;
import org.apache.commons.pool2.ObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftClient<T extends TServiceClient>
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ThriftClient.class);
    private final TServiceClient client;
    private final ObjectPool<ThriftClient<T>> pool;
    private final ServiceInfo serviceInfo;
    private boolean finish;

    public ThriftClient(TServiceClient client, ObjectPool<ThriftClient<T>> pool, ServiceInfo serviceInfo) {
        this.client = client;
        this.pool = pool;
        this.serviceInfo = serviceInfo;
    }

    public ServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    public T iface() {
        return (T)this.client;
    }

    @Override
    public void close() {
        try {
            if (this.finish) {
                logger.info("return object to pool: " + this);
                this.finish = false;
                this.pool.returnObject((Object)this);
            } else {
                logger.warn("not return object cause not finish {}", (Object)this.client);
                this.closeClient();
                this.pool.invalidateObject((Object)this);
            }
        }
        catch (Exception e) {
            logger.warn("return object fail, close", (Throwable)e);
            this.closeClient();
        }
    }

    void closeClient() {
        logger.debug("close client {}", (Object)this);
        ThriftUtil.closeClient(this.client);
    }

    public void finish() {
        this.finish = true;
    }

    void setFinish(boolean finish) {
        this.finish = finish;
    }

    public boolean isDisConnected() {
        TTransport inputTransport = this.client.getInputProtocol().getTransport();
        TTransport outputTransport = this.client.getOutputProtocol().getTransport();
        return !inputTransport.isOpen() || !outputTransport.isOpen();
    }
}

