/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.amoro.TableFormat;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.thrift.org.apache.commons.lang3.tuple.Pair;

public final class Action {
    private static final Map<Integer, Action> ACTIONS = Maps.newConcurrentMap();
    private static final TableFormat[] DEFAULT_FORMATS = new TableFormat[]{TableFormat.ICEBERG, TableFormat.MIXED_ICEBERG, TableFormat.MIXED_HIVE};
    private final TableFormat[] formats;
    private final int code;
    private final int weight;
    private final String desc;

    private Action(TableFormat[] formats, int code, int weight, String desc) {
        this.formats = formats;
        this.code = code;
        this.desc = desc;
        this.weight = weight;
    }

    public static Action valueOf(int code) {
        return ACTIONS.get(code);
    }

    public static synchronized void register(int code, int weight, String desc) {
        Action.register(DEFAULT_FORMATS, code, weight, desc);
    }

    public static synchronized void register(TableFormat[] formats, int code, int weight, String desc) {
        Map<TableFormat, Set<String>> format2Actions = Action.buildMapFromActions();
        for (TableFormat format : formats) {
            if (!format2Actions.get(format).contains(desc)) continue;
            throw new IllegalArgumentException("Duplicated action: " + desc + " in format: " + format);
        }
        if (ACTIONS.put(code, new Action(formats, code, weight, desc)) != null) {
            throw new IllegalArgumentException("Duplicated action code: " + code);
        }
    }

    private static Map<TableFormat, Set<String>> buildMapFromActions() {
        return ACTIONS.values().stream().flatMap(action -> Arrays.stream(action.formats).map(format -> Pair.of((Object)format, (Object)action.desc))).collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Pair::getValue, Collectors.toSet())));
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public int getWeight() {
        return this.weight;
    }

    public TableFormat[] supportedFormats() {
        return this.formats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Action action = (Action)o;
        return this.code == action.code;
    }

    public int hashCode() {
        return this.code;
    }

    static {
        Action.register(1, 10, "rewrite");
        Action.register(4, 1, "expire-data");
        Action.register(5, 2, "delete-orphans");
        Action.register(6, 3, "sync-hive");
    }
}

