/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.GetCrawlerMetricsRequest;
import software.amazon.awssdk.services.glue.model.GetCrawlerMetricsResponse;

public class GetCrawlerMetricsPublisher
implements SdkPublisher<GetCrawlerMetricsResponse> {
    private final GlueAsyncClient client;
    private final GetCrawlerMetricsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetCrawlerMetricsPublisher(GlueAsyncClient client, GetCrawlerMetricsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetCrawlerMetricsPublisher(GlueAsyncClient client, GetCrawlerMetricsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetCrawlerMetricsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetCrawlerMetricsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetCrawlerMetricsResponseFetcher
    implements AsyncPageFetcher<GetCrawlerMetricsResponse> {
        private GetCrawlerMetricsResponseFetcher() {
        }

        public boolean hasNextPage(GetCrawlerMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetCrawlerMetricsResponse> nextPage(GetCrawlerMetricsResponse previousPage) {
            if (previousPage == null) {
                return GetCrawlerMetricsPublisher.this.client.getCrawlerMetrics(GetCrawlerMetricsPublisher.this.firstRequest);
            }
            return GetCrawlerMetricsPublisher.this.client.getCrawlerMetrics((GetCrawlerMetricsRequest)((Object)GetCrawlerMetricsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

