/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ParamType {
    STR("str"),
    INT("int"),
    FLOAT("float"),
    COMPLEX("complex"),
    BOOL("bool"),
    LIST("list"),
    NULL("null"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ParamType> VALUE_MAP;
    private final String value;

    private ParamType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ParamType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ParamType> knownValues() {
        EnumSet<ParamType> knownValues = EnumSet.allOf(ParamType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ParamType.class, ParamType::toString);
    }
}

