/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.AmazonRedshiftNodeData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AmazonRedshiftSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AmazonRedshiftSource> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AmazonRedshiftSource.getter(AmazonRedshiftSource::name)).setter(AmazonRedshiftSource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<AmazonRedshiftNodeData> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Data").getter(AmazonRedshiftSource.getter(AmazonRedshiftSource::data)).setter(AmazonRedshiftSource.setter(Builder::data)).constructor(AmazonRedshiftNodeData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final AmazonRedshiftNodeData data;

    private AmazonRedshiftSource(BuilderImpl builder) {
        this.name = builder.name;
        this.data = builder.data;
    }

    public final String name() {
        return this.name;
    }

    public final AmazonRedshiftNodeData data() {
        return this.data;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonRedshiftSource)) {
            return false;
        }
        AmazonRedshiftSource other = (AmazonRedshiftSource)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.data(), other.data());
    }

    public final String toString() {
        return ToString.builder((String)"AmazonRedshiftSource").add("Name", (Object)this.name()).add("Data", (Object)this.data()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AmazonRedshiftSource, T> g) {
        return obj -> g.apply((AmazonRedshiftSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private AmazonRedshiftNodeData data;

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonRedshiftSource model) {
            this.name(model.name);
            this.data(model.data);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AmazonRedshiftNodeData.Builder getData() {
            return this.data != null ? this.data.toBuilder() : null;
        }

        public final void setData(AmazonRedshiftNodeData.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        @Override
        public final Builder data(AmazonRedshiftNodeData data) {
            this.data = data;
            return this;
        }

        public AmazonRedshiftSource build() {
            return new AmazonRedshiftSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AmazonRedshiftSource> {
        public Builder name(String var1);

        public Builder data(AmazonRedshiftNodeData var1);

        default public Builder data(Consumer<AmazonRedshiftNodeData.Builder> data) {
            return this.data((AmazonRedshiftNodeData)((AmazonRedshiftNodeData.Builder)AmazonRedshiftNodeData.builder().applyMutation(data)).build());
        }
    }
}

