/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized;

import java.math.BigDecimal;
import org.apache.arrow.vector.FieldVector;
import org.apache.iceberg.arrow.DictEncodedArrowConverter;
import org.apache.iceberg.arrow.vectorized.ArrowVectorAccessor;
import org.apache.iceberg.arrow.vectorized.ArrowVectorAccessors;
import org.apache.iceberg.arrow.vectorized.NullabilityHolder;
import org.apache.iceberg.arrow.vectorized.VectorHolder;

public class ColumnVector
implements AutoCloseable {
    private final VectorHolder vectorHolder;
    private final ArrowVectorAccessor<?, String, ?, ?> accessor;
    private final NullabilityHolder nullabilityHolder;

    ColumnVector(VectorHolder vectorHolder) {
        this.vectorHolder = vectorHolder;
        this.nullabilityHolder = vectorHolder.nullabilityHolder();
        this.accessor = ColumnVector.getVectorAccessor(vectorHolder);
    }

    public FieldVector getFieldVector() {
        return this.vectorHolder.vector();
    }

    public FieldVector getArrowVector() {
        return DictEncodedArrowConverter.toArrowVector(this.vectorHolder, this.accessor);
    }

    public boolean hasNull() {
        return this.nullabilityHolder.hasNulls();
    }

    public int numNulls() {
        return this.nullabilityHolder.numNulls();
    }

    @Override
    public void close() {
        this.accessor.close();
    }

    public boolean isNullAt(int rowId) {
        return this.nullabilityHolder.isNullAt(rowId) == 1;
    }

    public boolean getBoolean(int rowId) {
        return this.accessor.getBoolean(rowId);
    }

    public int getInt(int rowId) {
        return this.accessor.getInt(rowId);
    }

    public long getLong(int rowId) {
        return this.accessor.getLong(rowId);
    }

    public float getFloat(int rowId) {
        return this.accessor.getFloat(rowId);
    }

    public double getDouble(int rowId) {
        return this.accessor.getDouble(rowId);
    }

    public String getString(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getUTF8String(rowId);
    }

    public byte[] getBinary(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getBinary(rowId);
    }

    public BigDecimal getDecimal(int rowId, int precision, int scale) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return (BigDecimal)this.accessor.getDecimal(rowId, precision, scale);
    }

    private static ArrowVectorAccessor<?, String, ?, ?> getVectorAccessor(VectorHolder holder) {
        return ArrowVectorAccessors.getVectorAccessor(holder);
    }
}

