/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.vectorized;

import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.sql.vectorized.ColumnarRow;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

@Evolving
public abstract class ColumnVector
implements AutoCloseable {
    protected DataType type;

    public final DataType dataType() {
        return this.type;
    }

    @Override
    public abstract void close();

    public abstract boolean hasNull();

    public abstract int numNulls();

    public abstract boolean isNullAt(int var1);

    public abstract boolean getBoolean(int var1);

    public boolean[] getBooleans(int rowId, int count) {
        boolean[] res = new boolean[count];
        for (int i = 0; i < count; ++i) {
            res[i] = this.getBoolean(rowId + i);
        }
        return res;
    }

    public abstract byte getByte(int var1);

    public byte[] getBytes(int rowId, int count) {
        byte[] res = new byte[count];
        for (int i = 0; i < count; ++i) {
            res[i] = this.getByte(rowId + i);
        }
        return res;
    }

    public abstract short getShort(int var1);

    public short[] getShorts(int rowId, int count) {
        short[] res = new short[count];
        for (int i = 0; i < count; ++i) {
            res[i] = this.getShort(rowId + i);
        }
        return res;
    }

    public abstract int getInt(int var1);

    public int[] getInts(int rowId, int count) {
        int[] res = new int[count];
        for (int i = 0; i < count; ++i) {
            res[i] = this.getInt(rowId + i);
        }
        return res;
    }

    public abstract long getLong(int var1);

    public long[] getLongs(int rowId, int count) {
        long[] res = new long[count];
        for (int i = 0; i < count; ++i) {
            res[i] = this.getLong(rowId + i);
        }
        return res;
    }

    public abstract float getFloat(int var1);

    public float[] getFloats(int rowId, int count) {
        float[] res = new float[count];
        for (int i = 0; i < count; ++i) {
            res[i] = this.getFloat(rowId + i);
        }
        return res;
    }

    public abstract double getDouble(int var1);

    public double[] getDoubles(int rowId, int count) {
        double[] res = new double[count];
        for (int i = 0; i < count; ++i) {
            res[i] = this.getDouble(rowId + i);
        }
        return res;
    }

    public final ColumnarRow getStruct(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return new ColumnarRow(this, rowId);
    }

    public abstract ColumnarArray getArray(int var1);

    public abstract ColumnarMap getMap(int var1);

    public abstract Decimal getDecimal(int var1, int var2, int var3);

    public abstract UTF8String getUTF8String(int var1);

    public abstract byte[] getBinary(int var1);

    public final CalendarInterval getInterval(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        int months = this.getChild(0).getInt(rowId);
        int days = this.getChild(1).getInt(rowId);
        long microseconds = this.getChild(2).getLong(rowId);
        return new CalendarInterval(months, days, microseconds);
    }

    public abstract ColumnVector getChild(int var1);

    protected ColumnVector(DataType type) {
        this.type = type;
    }
}

