/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.ParseToTimestamp$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(timestamp_str[, fmt]) - Parses the `timestamp_str` expression with the `fmt` expression\n      to a timestamp. Returns null with invalid input. By default, it follows casting rules to\n      a timestamp if the `fmt` is omitted. The result data type is consistent with the value of\n      configuration `spark.sql.timestampType`.\n  ", arguments="\n    Arguments:\n      * timestamp_str - A string to be parsed to timestamp.\n      * fmt - Timestamp format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-12-31 00:12:00');\n       2016-12-31 00:12:00\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31 00:00:00\n  ", group="datetime_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\t%c\u0001B\u0014)\u0001VB\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005m!Aq\n\u0001BK\u0002\u0013\u0005\u0001\u000b\u0003\u0005U\u0001\tE\t\u0015!\u0003R\u0011!)\u0006A!f\u0001\n\u00032\u0006\u0002C/\u0001\u0005#\u0005\u000b\u0011B,\t\u0011y\u0003!Q3A\u0005\u0002}C\u0001\u0002\u001c\u0001\u0003\u0012\u0003\u0006I\u0001\u0019\u0005\u0006[\u0002!\tA\u001c\u0005\ti\u0002A)\u0019!C!\u001b\")Q\u000e\u0001C\u0001k\")Q\u000e\u0001C\u0001q\")!\u0010\u0001C!w\")A\u0010\u0001C!{\"9\u0011\u0011\b\u0001\u0005B\u0005m\u0002bBA \u0001\u0011\u0005\u0013\u0011\t\u0005\b\u0003\u000b\u0002A\u0011IA$\u0011\u001d\t\t\u0006\u0001C)\u0003'B\u0011\"a\u0018\u0001\u0003\u0003%\t!!\u0019\t\u0013\u0005-\u0004!%A\u0005\u0002\u00055\u0004\"CAB\u0001E\u0005I\u0011AAC\u0011%\tI\tAI\u0001\n\u0003\tY\tC\u0005\u0002\u0010\u0002\t\n\u0011\"\u0001\u0002\u0012\"I\u0011Q\u0013\u0001\u0002\u0002\u0013\u0005\u0013q\u0013\u0005\n\u0003O\u0003\u0011\u0011!C\u0001\u0003SC\u0011\"!-\u0001\u0003\u0003%\t!a-\t\u0013\u0005}\u0006!!A\u0005B\u0005\u0005\u0007\"CAh\u0001\u0005\u0005I\u0011AAi\u0011%\tY\u000eAA\u0001\n\u0003\ninB\u0005\u0003\b!\n\t\u0011#\u0001\u0003\n\u0019Aq\u0005KA\u0001\u0012\u0003\u0011Y\u0001\u0003\u0004n?\u0011\u0005!\u0011\u0004\u0005\n\u00057y\u0012\u0011!C#\u0005;A\u0011Ba\b \u0003\u0003%\tI!\t\t\u0013\t-r$%A\u0005\u0002\u0005E\u0005\"\u0003B\u0017?\u0005\u0005I\u0011\u0011B\u0018\u0011%\u0011idHI\u0001\n\u0003\t\t\nC\u0005\u0003@}\t\t\u0011\"\u0003\u0003B\t\u0001\u0002+\u0019:tKR{G+[7fgR\fW\u000e\u001d\u0006\u0003S)\n1\"\u001a=qe\u0016\u001c8/[8og*\u00111\u0006L\u0001\tG\u0006$\u0018\r\\=ti*\u0011QFL\u0001\u0004gFd'BA\u00181\u0003\u0015\u0019\b/\u0019:l\u0015\t\t$'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002g\u0005\u0019qN]4\u0004\u0001M9\u0001A\u000e\u001e>\u0001\u000eK\u0005CA\u001c9\u001b\u0005A\u0013BA\u001d)\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003omJ!\u0001\u0010\u0015\u0003%I+h\u000e^5nKJ+\u0007\u000f\\1dK\u0006\u0014G.\u001a\t\u0003oyJ!a\u0010\u0015\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"aN!\n\u0005\tC#a\u0006+j[\u0016TvN\\3Bo\u0006\u0014X-\u0012=qe\u0016\u001c8/[8o!\t!u)D\u0001F\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%F\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0012&\n\u0005-+%\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00027fMR,\u0012AN\u0001\u0006Y\u00164G\u000fI\u0001\u0007M>\u0014X.\u0019;\u0016\u0003E\u00032\u0001\u0012*7\u0013\t\u0019VI\u0001\u0004PaRLwN\\\u0001\bM>\u0014X.\u0019;!\u0003!!\u0017\r^1UsB,W#A,\u0011\u0005a[V\"A-\u000b\u0005ic\u0013!\u0002;za\u0016\u001c\u0018B\u0001/Z\u0005!!\u0015\r^1UsB,\u0017!\u00033bi\u0006$\u0016\u0010]3!\u0003)!\u0018.\\3[_:,\u0017\nZ\u000b\u0002AB\u0019AIU1\u0011\u0005\tLgBA2h!\t!W)D\u0001f\u0015\t1G'\u0001\u0004=e>|GOP\u0005\u0003Q\u0016\u000ba\u0001\u0015:fI\u00164\u0017B\u00016l\u0005\u0019\u0019FO]5oO*\u0011\u0001.R\u0001\fi&lWMW8oK&#\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0006_B\f(o\u001d\t\u0003o\u0001AQ\u0001T\u0005A\u0002YBQaT\u0005A\u0002ECQ!V\u0005A\u0002]CqAX\u0005\u0011\u0002\u0003\u0007\u0001-A\u0006sKBd\u0017mY3nK:$HcA8wo\")Aj\u0003a\u0001m!)qj\u0003a\u0001mQ\u0011q.\u001f\u0005\u0006\u00192\u0001\rAN\u0001\t]>$WMT1nKV\t\u0011-\u0001\u000bo_\u0012,\u0007+\u0019;uKJt7/\u00138uKJt\u0017\r\u001c\u000b\u0002}B)q0!\u0003\u0002\u00109!\u0011\u0011AA\u0003\u001d\r!\u00171A\u0005\u0002\r&\u0019\u0011qA#\u0002\u000fA\f7m[1hK&!\u00111BA\u0007\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u000f)\u0005\u0003BA\t\u0003gqA!a\u0005\u0002.9!\u0011QCA\u0015\u001d\u0011\t9\"a\n\u000f\t\u0005e\u0011Q\u0005\b\u0005\u00037\t\u0019C\u0004\u0003\u0002\u001e\u0005\u0005bb\u00013\u0002 %\t1'\u0003\u00022e%\u0011q\u0006M\u0005\u0003[9J!a\u000b\u0017\n\u0007\u0005-\"&A\u0003ue\u0016,7/\u0003\u0003\u00020\u0005E\u0012a\u0003+sK\u0016\u0004\u0016\r\u001e;fe:T1!a\u000b+\u0013\u0011\t)$a\u000e\u0003\u0017Q\u0013X-\u001a)biR,'O\u001c\u0006\u0005\u0003_\t\t$\u0001\u0007xSRDG+[7f5>tW\rF\u0002A\u0003{AQAX\bA\u0002\u0005\f\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0003\u0003\u0007\u0002Ba`A\u0005m\u0005Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005%\u0003#B@\u0002\n\u0005-\u0003c\u0001-\u0002N%\u0019\u0011qJ-\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\r1\u0014Q\u000b\u0005\b\u0003/\u0012\u0002\u0019AA-\u0003-qWm^\"iS2$'/\u001a8\u0011\t}\fYFN\u0005\u0005\u0003;\niA\u0001\u0006J]\u0012,\u00070\u001a3TKF\fAaY8qsRIq.a\u0019\u0002f\u0005\u001d\u0014\u0011\u000e\u0005\b\u0019N\u0001\n\u00111\u00017\u0011\u001dy5\u0003%AA\u0002ECq!V\n\u0011\u0002\u0003\u0007q\u000bC\u0004_'A\u0005\t\u0019\u00011\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u000e\u0016\u0004m\u0005E4FAA:!\u0011\t)(a \u000e\u0005\u0005]$\u0002BA=\u0003w\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005uT)\u0001\u0006b]:|G/\u0019;j_:LA!!!\u0002x\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0011\u0016\u0004#\u0006E\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u001bS3aVA9\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!a%+\u0007\u0001\f\t(A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00033\u0003B!a'\u0002&6\u0011\u0011Q\u0014\u0006\u0005\u0003?\u000b\t+\u0001\u0003mC:<'BAAR\u0003\u0011Q\u0017M^1\n\u0007)\fi*\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002,B\u0019A)!,\n\u0007\u0005=VIA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00026\u0006m\u0006c\u0001#\u00028&\u0019\u0011\u0011X#\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002>j\t\t\u00111\u0001\u0002,\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a1\u0011\r\u0005\u0015\u00171ZA[\u001b\t\t9MC\u0002\u0002J\u0016\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti-a2\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003'\fI\u000eE\u0002E\u0003+L1!a6F\u0005\u001d\u0011un\u001c7fC:D\u0011\"!0\u001d\u0003\u0003\u0005\r!!.\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019.a8\t\u0013\u0005uV$!AA\u0002\u0005U\u0006f\u0006\u0001\u0002d\u0006%\u00181^Ax\u0003c\f)0a>\u0002|\u0006u(\u0011\u0001B\u0002!\r9\u0014Q]\u0005\u0004\u0003OD#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003[\f!\u0011\u0016\u0006!A\u0001\u0002sLR+O\u0007~CC/[7fgR\fW\u000e]0tiJ\\F\u0006\t4nivK\u0003%\f\u0011QCJ\u001cXm\u001d\u0011uQ\u0016\u0004\u0003\r^5nKN$\u0018-\u001c9`gR\u0014\b\rI3yaJ,7o]5p]\u0002:\u0018\u000e\u001e5!i\",\u0007\u0005\u00194ni\u0002\u0004S\r\u001f9sKN\u001c\u0018n\u001c8\u000bA\u0001\u0002\u0003\u0005\t\u0011u_\u0002\n\u0007\u0005^5nKN$\u0018-\u001c9/AI+G/\u001e:og\u0002rW\u000f\u001c7!o&$\b\u000eI5om\u0006d\u0017\u000e\u001a\u0011j]B,HO\f\u0011Cs\u0002\"WMZ1vYRd\u0003%\u001b;!M>dGn\\<tA\r\f7\u000f^5oO\u0002\u0012X\u000f\\3tAQ|'\u0002\t\u0011!A\u0001\u0002\u0013\r\t;j[\u0016\u001cH/Y7qA%4\u0007\u0005\u001e5fA\u00014W\u000e\u001e1!SN\u0004s.\\5ui\u0016$g\u0006\t+iK\u0002\u0012Xm];mi\u0002\"\u0017\r^1!if\u0004X\rI5tA\r|gn]5ti\u0016tG\u000fI<ji\"\u0004C\u000f[3!m\u0006dW/\u001a\u0011pM*\u0001\u0003\u0005\t\u0011!A\r|gNZ5hkJ\fG/[8oA\u0001\u001c\b/\u0019:l]M\fHN\f;j[\u0016\u001cH/Y7q)f\u0004X\r\u0019\u0018\u000bA\u0001\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005M\u0018A!\u0010\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"\u0018.\\3ti\u0006l\u0007oX:ue\u0002j\u0003%\u0011\u0011tiJLgn\u001a\u0011u_\u0002\u0012W\r\t9beN,G\r\t;pAQLW.Z:uC6\u0004hF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011g[R\u0004S\u0006\t+j[\u0016\u001cH/Y7qA\u0019|'/\\1uAA\fG\u000f^3s]\u0002\"x\u000e\t4pY2|wO\f\u0011TK\u0016\u0004C(\u0019\u0011ie\u00164WH\t5uiB\u001c(hL\u0018ta\u0006\u00148NL1qC\u000eDWML8sO>\"wnY:0Y\u0006$Xm\u001d;0gFdWF]3g[\u0011\fG/\u001a;j[\u0016l\u0003/\u0019;uKJtg\u0006\u001b;nY\nrD)\u0019;fi&lW\r\t)biR,'O\\:=_\u0005t\u0004EZ8sAY\fG.\u001b3\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!I\u0006$X\rI1oI\u0002\"\u0018.\\3!M>\u0014X.\u0019;!a\u0006$H/\u001a:og:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011`\u0001\u0002R)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00192m5\n$'L\u001a2AA\u0002$(\r\u001a;aA:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE2T&\r\u001a.gE\u0002\u0003\u0007\r\u001e2ei\u0002\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(eA\nd'L\u00193[M\nt\u0005\f\u0011(sfL\u00180L'N[\u0011$w%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\nd'L\u00193[M\n\u0004\u0005\r\u0019;aAR\u0004\u0007\r\u0006!A\u0005)qM]8va\u0006\u0012\u0011q`\u0001\u000fI\u0006$X\r^5nK~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0011)!A\u00033]Ir\u0003'\u0001\tQCJ\u001cX\rV8US6,7\u000f^1naB\u0011qgH\n\u0005?\t5\u0011\nE\u0005\u0003\u0010\tUa'U,a_6\u0011!\u0011\u0003\u0006\u0004\u0005')\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005/\u0011\tBA\tBEN$(/Y2u\rVt7\r^5p]R\"\"A!\u0003\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!'\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013=\u0014\u0019C!\n\u0003(\t%\u0002\"\u0002'#\u0001\u00041\u0004\"B(#\u0001\u0004\t\u0006\"B+#\u0001\u00049\u0006b\u00020#!\u0003\u0005\r\u0001Y\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u00059QO\\1qa2LH\u0003\u0002B\u0019\u0005s\u0001B\u0001\u0012*\u00034A9AI!\u000e7#^\u0003\u0017b\u0001B\u001c\u000b\n1A+\u001e9mKRB\u0001Ba\u000f%\u0003\u0003\u0005\ra\\\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\"!\u0011\tYJ!\u0012\n\t\t\u001d\u0013Q\u0014\u0002\u0007\u001f\nTWm\u0019;")
public class ParseToTimestamp
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
TimeZoneAwareExpression,
scala.Serializable {
    private Expression replacement;
    private final Expression left;
    private final Option<Expression> format;
    private final DataType dataType;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private Expression canonicalized;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$4() {
        return ParseToTimestamp$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<Expression, Option<Expression>, DataType, Option<String>>> unapply(ParseToTimestamp parseToTimestamp) {
        return ParseToTimestamp$.MODULE$.unapply(parseToTimestamp);
    }

    public static Option<String> apply$default$4() {
        return ParseToTimestamp$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<Expression, Option<Expression>, DataType, Option<String>>, ParseToTimestamp> tupled() {
        return ParseToTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<DataType, Function1<Option<String>, ParseToTimestamp>>>> curried() {
        return ParseToTimestamp$.MODULE$.curried();
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return !this.bitmap$trans$0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private Expression canonicalized$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    private Expression replacement$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = (Expression)this.format().map((Function1 & Serializable & scala.Serializable)f -> new GetTimestamp(this.left(), (Expression)f, this.dataType(), this.timeZoneId(), GetTimestamp$.MODULE$.apply$default$5())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Cast(this.left(), this.dataType(), this.timeZoneId(), Cast$.MODULE$.apply$default$4()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.replacement$lzycompute() : this.replacement;
    }

    @Override
    public String nodeName() {
        return "to_timestamp";
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return (Seq)new .colon.colon((Object)TreePattern$.MODULE$.RUNTIME_REPLACEABLE(), (List)Nil$.MODULE$);
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Some x$1 = new Some((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        DataType x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.left();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        Seq types = (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)DateType$.MODULE$, (List)new .colon.colon((Object)TimestampType$.MODULE$, (List)new .colon.colon((Object)TimestampNTZType$.MODULE$, (List)Nil$.MODULE$))));
        TypeCollection typeCollection = TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)(this.dataType() instanceof TimestampType ? (Seq)types.$colon$plus((Object)NumericType$.MODULE$, Seq$.MODULE$.canBuildFrom()) : types));
        return (Seq)Option$.MODULE$.option2Iterable(this.format().map((Function1 & Serializable & scala.Serializable)x$10 -> StringType$.MODULE$)).toSeq().$plus$colon((Object)typeCollection, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.format().isDefined() ? this.copy((Expression)newChildren.head(), (Option<Expression>)new Some(newChildren.last()), this.copy$default$3(), this.copy$default$4()) : this.copy((Expression)newChildren.head(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public ParseToTimestamp copy(Expression left, Option<Expression> format, DataType dataType, Option<String> timeZoneId) {
        return new ParseToTimestamp(left, format, dataType, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public DataType copy$default$3() {
        return this.dataType();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "ParseToTimestamp";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.dataType();
                break;
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToTimestamp parseToTimestamp = (ParseToTimestamp)x$1;
        Expression expression = this.left();
        Expression expression2 = parseToTimestamp.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToTimestamp.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        DataType dataType = this.dataType();
        DataType dataType2 = parseToTimestamp.dataType();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        Option<String> option3 = this.timeZoneId();
        Option<String> option4 = parseToTimestamp.timeZoneId();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!parseToTimestamp.canEqual(this)) return false;
        return true;
    }

    public ParseToTimestamp(Expression left, Option<Expression> format, DataType dataType, Option<String> timeZoneId) {
        this.left = left;
        this.format = format;
        this.dataType = dataType;
        this.timeZoneId = timeZoneId;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        TimeZoneAwareExpression.$init$(this);
    }

    public ParseToTimestamp(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), SQLConf$.MODULE$.get().timestampType(), ParseToTimestamp$.MODULE$.$lessinit$greater$default$4());
    }

    public ParseToTimestamp(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, SQLConf$.MODULE$.get().timestampType(), ParseToTimestamp$.MODULE$.$lessinit$greater$default$4());
    }
}

