/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HashExpression;
import org.apache.spark.sql.catalyst.expressions.Murmur3Hash$;
import org.apache.spark.sql.catalyst.expressions.Murmur3HashFunction$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr1, expr2, ...) - Returns a hash value of the arguments.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', array(123), 2);\n       -1321691492\n  ", since="2.0.0", group="hash_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001\u0002\u000f\u001e\u0001*B\u0001b\u000f\u0001\u0003\u0016\u0004%\t\u0001\u0010\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005{!AQ\n\u0001BK\u0002\u0013\u0005a\n\u0003\u0005P\u0001\tE\t\u0015!\u00030\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015\u0001\u0006\u0001\"\u0001V\u0011\u0015A\u0006\u0001\"\u0011Z\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015Q\u0007\u0001\"\u0015b\u0011\u0015Y\u0007\u0001\"\u0015m\u0011\u0015!\b\u0001\"\u0015v\u0011\u001dY\b!!A\u0005\u0002qD\u0001b \u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0001\u0005\n\u0003/\u0001\u0011\u0013!C\u0001\u00033A\u0011\"!\b\u0001\u0003\u0003%\t%a\b\t\u0011\u0005=\u0002!!A\u0005\u00029C\u0011\"!\r\u0001\u0003\u0003%\t!a\r\t\u0013\u0005e\u0002!!A\u0005B\u0005m\u0002\"CA%\u0001\u0005\u0005I\u0011AA&\u0011%\t)\u0006AA\u0001\n\u0003\n9fB\u0005\u0002|u\t\t\u0011#\u0001\u0002~\u0019AA$HA\u0001\u0012\u0003\ty\b\u0003\u0004Q-\u0011\u0005\u0011Q\u0012\u0005\n\u0003\u001f3\u0012\u0011!C#\u0003#C\u0011\"a%\u0017\u0003\u0003%\t)!&\t\u0013\u0005me#!A\u0005\u0002\u0006u\u0005\"CAX-\u0005\u0005I\u0011BAY\u0005-iUO]7veNB\u0015m\u001d5\u000b\u0005yy\u0012aC3yaJ,7o]5p]NT!\u0001I\u0011\u0002\u0011\r\fG/\u00197zgRT!AI\u0012\u0002\u0007M\fHN\u0003\u0002%K\u0005)1\u000f]1sW*\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u00166qA\u0019A&L\u0018\u000e\u0003uI!AL\u000f\u0003\u001d!\u000b7\u000f[#yaJ,7o]5p]B\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t\u0019\u0011J\u001c;\u0011\u0005A2\u0014BA\u001c2\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001M\u001d\n\u0005i\n$\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001C2iS2$'/\u001a8\u0016\u0003u\u00022A\u0010$J\u001d\tyDI\u0004\u0002A\u00076\t\u0011I\u0003\u0002CS\u00051AH]8pizJ\u0011AM\u0005\u0003\u000bF\nq\u0001]1dW\u0006<W-\u0003\u0002H\u0011\n\u00191+Z9\u000b\u0005\u0015\u000b\u0004C\u0001\u0017K\u0013\tYUD\u0001\u0006FqB\u0014Xm]:j_:\f\u0011b\u00195jY\u0012\u0014XM\u001c\u0011\u0002\tM,W\rZ\u000b\u0002_\u0005)1/Z3eA\u00051A(\u001b8jiz\"2AU*U!\ta\u0003\u0001C\u0003<\u000b\u0001\u0007Q\bC\u0003N\u000b\u0001\u0007q\u0006\u0006\u0002S-\")qK\u0002a\u0001{\u0005I\u0011M]4v[\u0016tGo]\u0001\tI\u0006$\u0018\rV=qKV\t!\f\u0005\u0002\\=6\tAL\u0003\u0002^C\u0005)A/\u001f9fg&\u0011q\f\u0018\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003\t\u0004\"aY4\u000f\u0005\u0011,\u0007C\u0001!2\u0013\t1\u0017'\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q&\u0014aa\u0015;sS:<'B\u000142\u0003=A\u0017m\u001d5fe\u000ec\u0017m]:OC6,\u0017aC2p[B,H/\u001a%bg\"$BaL7sg\")aN\u0003a\u0001_\u0006)a/\u00197vKB\u0011\u0001\u0007]\u0005\u0003cF\u00121!\u00118z\u0011\u0015A&\u00021\u0001[\u0011\u0015i%\u00021\u00010\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000e\u0006\u0002Sm\")qo\u0003a\u0001q\u0006Ya.Z<DQ&dGM]3o!\rq\u00140S\u0005\u0003u\"\u0013!\"\u00138eKb,GmU3r\u0003\u0011\u0019w\u000e]=\u0015\u0007Ikh\u0010C\u0004<\u0019A\u0005\t\u0019A\u001f\t\u000f5c\u0001\u0013!a\u0001_\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0002U\ri\u0014QA\u0016\u0003\u0003\u000f\u0001B!!\u0003\u0002\u00145\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011C\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0016\u0005-!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\u000eU\ry\u0013QA\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003[i!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\u0005Y\u0006twM\u0003\u0002\u0002,\u0005!!.\u0019<b\u0013\rA\u0017QE\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\ry\u0017Q\u0007\u0005\t\u0003o\t\u0012\u0011!a\u0001_\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u0010\u0011\u000b\u0005}\u0012QI8\u000e\u0005\u0005\u0005#bAA\"c\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0013\u0011\t\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002N\u0005M\u0003c\u0001\u0019\u0002P%\u0019\u0011\u0011K\u0019\u0003\u000f\t{w\u000e\\3b]\"A\u0011qG\n\u0002\u0002\u0003\u0007q.\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u001b\nI\u0006\u0003\u0005\u00028Q\t\t\u00111\u0001pQM\u0001\u0011QLA2\u0003K\nI'a\u001b\u0002p\u0005E\u0014QOA<!\ra\u0013qL\u0005\u0004\u0003Cj\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003O\n!i\u0018$V\u001d\u000e{\u0006&\u001a=qeFb\u0003%\u001a=qeJb\u0003E\f\u0018/S\u0001j\u0003EU3ukJt7\u000fI1!Q\u0006\u001c\b\u000e\t<bYV,\u0007e\u001c4!i\",\u0007%\u0019:hk6,g\u000e^:/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA7\u0003MS\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ*qCJ\\w\u0005\f\u0011beJ\f\u0017\u0010K\u00193g%b\u0003EM\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A5\n4GM\u00197sE\"\u0014H\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u00111O\u0001\u0006e9\u0002d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003s\n!\u0002[1tQ~3WO\\2t\u0003-iUO]7veNB\u0015m\u001d5\u0011\u0005122\u0003\u0002\f\u0002\u0002b\u0002r!a!\u0002\nvz#+\u0004\u0002\u0002\u0006*\u0019\u0011qQ\u0019\u0002\u000fI,h\u000e^5nK&!\u00111RAC\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003{\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003C\tQ!\u00199qYf$RAUAL\u00033CQaO\rA\u0002uBQ!T\rA\u0002=\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002 \u0006-\u0006#\u0002\u0019\u0002\"\u0006\u0015\u0016bAARc\t1q\n\u001d;j_:\u0004R\u0001MAT{=J1!!+2\u0005\u0019!V\u000f\u001d7fe!A\u0011Q\u0016\u000e\u0002\u0002\u0003\u0007!+A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0017\t\u0005\u0003G\t),\u0003\u0003\u00028\u0006\u0015\"AB(cU\u0016\u001cG\u000f")
public class Murmur3Hash
extends HashExpression<Object>
implements Serializable {
    private final Seq<Expression> children;
    private final int seed;

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(Murmur3Hash murmur3Hash) {
        return Murmur3Hash$.MODULE$.unapply(murmur3Hash);
    }

    public static Function1<Tuple2<Seq<Expression>, Object>, Murmur3Hash> tupled() {
        return Murmur3Hash$.MODULE$.tupled();
    }

    public static Function1<Seq<Expression>, Function1<Object, Murmur3Hash>> curried() {
        return Murmur3Hash$.MODULE$.curried();
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public int seed() {
        return this.seed;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "hash";
    }

    @Override
    public String hasherClassName() {
        return Murmur3_x86_32.class.getName();
    }

    @Override
    public int computeHash(Object value, DataType dataType, int seed) {
        return (int)Murmur3HashFunction$.MODULE$.hash(value, dataType, seed);
    }

    @Override
    public Murmur3Hash withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren, this.copy$default$2());
    }

    public Murmur3Hash copy(Seq<Expression> children2, int seed) {
        return new Murmur3Hash(children2, seed);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public int copy$default$2() {
        return this.seed();
    }

    @Override
    public String productPrefix() {
        return "Murmur3Hash";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.seed());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Murmur3Hash;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Murmur3Hash)) return false;
        boolean bl = true;
        if (!bl) return false;
        Murmur3Hash murmur3Hash = (Murmur3Hash)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = murmur3Hash.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.seed() != murmur3Hash.seed()) return false;
        if (!murmur3Hash.canEqual(this)) return false;
        return true;
    }

    public Murmur3Hash(Seq<Expression> children2, int seed) {
        this.children = children2;
        this.seed = seed;
    }

    public Murmur3Hash(Seq<Expression> arguments) {
        this(arguments, 42);
    }
}

