/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MakeYMInterval$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_([years[, months]]) - Make year-month interval from years, months.", arguments="\n    Arguments:\n      * years - the number of years, positive or negative\n      * months - the number of months, positive or negative\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(1, 2);\n       1-2\n      > SELECT _FUNC_(1, 0);\n       1-0\n      > SELECT _FUNC_(-1, 1);\n       -0-11\n      > SELECT _FUNC_(2);\n       2-0\n  ", since="3.2.0", group="datetime_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001\u0002\u0011\"\u0001:B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u0011\"AA\n\u0001BK\u0002\u0013\u0005q\t\u0003\u0005N\u0001\tE\t\u0015!\u0003I\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015q\u0005\u0001\"\u0001T\u0011\u0015q\u0005\u0001\"\u0001V\u0011\u00151\u0006\u0001\"\u0011H\u0011\u00159\u0006\u0001\"\u0011H\u0011\u0015A\u0006\u0001\"\u0011Z\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u0015I\b\u0001\"\u0011{\u0011\u001d\t\t\u0002\u0001C!\u0003'Aq!!\n\u0001\t#\n9\u0003C\u0005\u00022\u0001\t\t\u0011\"\u0001\u00024!I\u0011\u0011\b\u0001\u0012\u0002\u0013\u0005\u00111\b\u0005\n\u0003#\u0002\u0011\u0013!C\u0001\u0003wA\u0011\"a\u0015\u0001\u0003\u0003%\t%!\u0016\t\u0013\u0005\u0015\u0004!!A\u0005\u0002\u0005\u001d\u0004\"CA8\u0001\u0005\u0005I\u0011AA9\u0011%\t9\bAA\u0001\n\u0003\nI\bC\u0005\u0002\b\u0002\t\t\u0011\"\u0001\u0002\n\"I\u00111\u0013\u0001\u0002\u0002\u0013\u0005\u0013QS\u0004\n\u0003\u007f\u000b\u0013\u0011!E\u0001\u0003\u00034\u0001\u0002I\u0011\u0002\u0002#\u0005\u00111\u0019\u0005\u0007\u001dj!\t!!5\t\u0013\u0005M'$!A\u0005F\u0005U\u0007\"CAl5\u0005\u0005I\u0011QAm\u0011%\tyNGA\u0001\n\u0003\u000b\t\u000fC\u0005\u0002tj\t\t\u0011\"\u0003\u0002v\nqQ*Y6f36Ke\u000e^3sm\u0006d'B\u0001\u0012$\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0011*\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0019:\u0013aA:rY*\u0011\u0001&K\u0001\u0006gB\f'o\u001b\u0006\u0003U-\na!\u00199bG\",'\"\u0001\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001y3GN\u001fD!\t\u0001\u0014'D\u0001\"\u0013\t\u0011\u0014E\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011\u0001\u0007N\u0005\u0003k\u0005\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003oir!\u0001\r\u001d\n\u0005e\n\u0013a\u00029bG.\fw-Z\u0005\u0003wq\u0012aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002:CA\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\ta1+\u001a:jC2L'0\u00192mKB\u0011a\bR\u0005\u0003\u000b~\u0012q\u0001\u0015:pIV\u001cG/A\u0003zK\u0006\u00148/F\u0001I!\t\u0001\u0014*\u0003\u0002KC\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\re,\u0017M]:!\u0003\u0019iwN\u001c;ig\u00069Qn\u001c8uQN\u0004\u0013A\u0002\u001fj]&$h\bF\u0002Q#J\u0003\"\u0001\r\u0001\t\u000b\u0019+\u0001\u0019\u0001%\t\u000b1+\u0001\u0019\u0001%\u0015\u0005A#\u0006\"\u0002$\u0007\u0001\u0004AE#\u0001)\u0002\t1,g\r^\u0001\u0006e&<\u0007\u000e^\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u0001.\u0011\u0007m\u0013WM\u0004\u0002]C:\u0011Q\fY\u0007\u0002=*\u0011q,L\u0001\u0007yI|w\u000e\u001e \n\u0003\u0001K!!O \n\u0005\r$'aA*fc*\u0011\u0011h\u0010\t\u0003M&l\u0011a\u001a\u0006\u0003Q\u0016\nQ\u0001^=qKNL!A[4\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u00035\u0004\"A\u001a8\n\u0005=<'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0007I,x\u000f\u0005\u0002?g&\u0011Ao\u0010\u0002\u0004\u0003:L\b\"\u0002<\r\u0001\u0004\u0011\u0018\u0001B=fCJDQ\u0001\u001f\u0007A\u0002I\fQ!\\8oi\"\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u000bm\f\u0019!!\u0004\u0011\u0005q|X\"A?\u000b\u0005y\f\u0013aB2pI\u0016<WM\\\u0005\u0004\u0003\u0003i(\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005\u0015Q\u00021\u0001\u0002\b\u0005\u00191\r\u001e=\u0011\u0007q\fI!C\u0002\u0002\fu\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000f\u0003\u0004\u0002\u00105\u0001\ra_\u0001\u0003KZ\f!\u0002\u001d:fiRLh*Y7f+\t\t)\u0002\u0005\u0003\u0002\u0018\u0005}a\u0002BA\r\u00037\u0001\"!X \n\u0007\u0005uq(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003C\t\u0019C\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003;y\u0014aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0015A\u0015\u0011FA\u0017\u0011\u0019\tYc\u0004a\u0001\u0011\u00069a.Z<MK\u001a$\bBBA\u0018\u001f\u0001\u0007\u0001*\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u000bA\u000b)$a\u000e\t\u000f\u0019\u0003\u0002\u0013!a\u0001\u0011\"9A\n\u0005I\u0001\u0002\u0004A\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003{Q3\u0001SA W\t\t\t\u0005\u0005\u0003\u0002D\u00055SBAA#\u0015\u0011\t9%!\u0013\u0002\u0013Ut7\r[3dW\u0016$'bAA&\u007f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0013Q\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005]\u0003\u0003BA-\u0003Gj!!a\u0017\u000b\t\u0005u\u0013qL\u0001\u0005Y\u0006twM\u0003\u0002\u0002b\u0005!!.\u0019<b\u0013\u0011\t\t#a\u0017\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005%\u0004c\u0001 \u0002l%\u0019\u0011QN \u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007I\f\u0019\bC\u0005\u0002vU\t\t\u00111\u0001\u0002j\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u001f\u0011\u000b\u0005u\u00141\u0011:\u000e\u0005\u0005}$bAAA\u007f\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0015\u0015q\u0010\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\f\u0006E\u0005c\u0001 \u0002\u000e&\u0019\u0011qR \u0003\u000f\t{w\u000e\\3b]\"A\u0011QO\f\u0002\u0002\u0003\u0007!/\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u0017\u000b9\n\u0003\u0005\u0002va\t\t\u00111\u0001sQ]\u0001\u00111TAQ\u0003G\u000b9+!+\u0002.\u0006=\u00161WA[\u0003s\u000bY\fE\u00021\u0003;K1!a(\"\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!*\u0002\u0011~3UKT\"`QmKX-\u0019:t72\u0002Sn\u001c8uQNlV,\u000b\u0011.A5\u000b7.\u001a\u0011zK\u0006\u0014X&\\8oi\"\u0004\u0013N\u001c;feZ\fG\u000e\t4s_6\u0004\u00130Z1sg2\u0002Sn\u001c8uQNt\u0013!C1sOVlWM\u001c;tC\t\tY+AA\t\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002\u00130Z1sg\u0002j\u0003\u0005\u001e5fA9,XNY3sA=4\u0007%_3beNd\u0003\u0005]8tSRLg/\u001a\u0011pe\u0002rWmZ1uSZ,'\u0002\t\u0011!A\u0001\u0002#\u0006I7p]RD7\u000fI\u0017!i\",\u0007E\\;nE\u0016\u0014\be\u001c4![>tG\u000f[:-AA|7/\u001b;jm\u0016\u0004sN\u001d\u0011oK\u001e\fG/\u001b<f\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005E\u0016!a\u0019\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QEb\u0003EM\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AEj#G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00152Y\u0001\u0002\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112[AR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&L\u0019-AEJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u00171[E\n$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012T\u0006\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qW\u0001\u0006g9\u0012d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003{\u000ba\u0002Z1uKRLW.Z0gk:\u001c7/\u0001\bNC.,\u0017,T%oi\u0016\u0014h/\u00197\u0011\u0005AR2\u0003\u0002\u000e\u0002Fv\u0002r!a2\u0002N\"C\u0005+\u0004\u0002\u0002J*\u0019\u00111Z \u0002\u000fI,h\u000e^5nK&!\u0011qZAe\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003\u0003\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003/\nQ!\u00199qYf$R\u0001UAn\u0003;DQAR\u000fA\u0002!CQ\u0001T\u000fA\u0002!\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002d\u0006=\b#\u0002 \u0002f\u0006%\u0018bAAt\u007f\t1q\n\u001d;j_:\u0004RAPAv\u0011\"K1!!<@\u0005\u0019!V\u000f\u001d7fe!A\u0011\u0011\u001f\u0010\u0002\u0002\u0003\u0007\u0001+A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u001f\t\u0005\u00033\nI0\u0003\u0003\u0002|\u0006m#AB(cU\u0016\u001cG\u000f")
public class MakeYMInterval
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression years;
    private final Expression months;

    public static Option<Tuple2<Expression, Expression>> unapply(MakeYMInterval makeYMInterval) {
        return MakeYMInterval$.MODULE$.unapply(makeYMInterval);
    }

    public static Function1<Tuple2<Expression, Expression>, MakeYMInterval> tupled() {
        return MakeYMInterval$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, MakeYMInterval>> curried() {
        return MakeYMInterval$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression years() {
        return this.years;
    }

    public Expression months() {
        return this.months;
    }

    @Override
    public Expression left() {
        return this.years();
    }

    @Override
    public Expression right() {
        return this.months();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return YearMonthIntervalType$.MODULE$.apply();
    }

    @Override
    public Object nullSafeEval(Object year, Object month) {
        return BoxesRunTime.boxToInteger((int)Math.toIntExact(Math.addExact(((Number)month).longValue(), Math.multiplyExact(((Number)year).longValue(), 12L))));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(years, months) -> {
            String math = new StringOps(Predef$.MODULE$.augmentString(Math.class.getName())).stripSuffix("$");
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(92).append("\n         |").append(math).append(".toIntExact(java.lang.Math.addExact(").append((String)months).append(",\n         |  ").append(math).append(".multiplyExact(").append((String)years).append(", ").append(12).append(")))\n         |").toString())).stripMargin();
        });
    }

    @Override
    public String prettyName() {
        return "make_ym_interval";
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public MakeYMInterval copy(Expression years, Expression months) {
        return new MakeYMInterval(years, months);
    }

    public Expression copy$default$1() {
        return this.years();
    }

    public Expression copy$default$2() {
        return this.months();
    }

    @Override
    public String productPrefix() {
        return "MakeYMInterval";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.years();
                break;
            }
            case 1: {
                expression = this.months();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeYMInterval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeYMInterval)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeYMInterval makeYMInterval = (MakeYMInterval)x$1;
        Expression expression = this.years();
        Expression expression2 = makeYMInterval.years();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.months();
        Expression expression4 = makeYMInterval.months();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!makeYMInterval.canEqual(this)) return false;
        return true;
    }

    public MakeYMInterval(Expression years, Expression months) {
        this.years = years;
        this.months = months;
        ExpectsInputTypes.$init$(this);
    }

    public MakeYMInterval(Expression years) {
        this(years, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeYMInterval() {
        this(Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }
}

