/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.V2ExpressionUtils$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression$;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.connector.distributions.ClusteredDistribution;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.distributions.OrderedDistribution;
import org.apache.spark.sql.connector.distributions.UnspecifiedDistribution;
import org.apache.spark.sql.connector.write.RequiresDistributionAndOrdering;
import org.apache.spark.sql.connector.write.Write;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;

public final class DistributionAndOrderingUtils$ {
    public static DistributionAndOrderingUtils$ MODULE$;

    static {
        new DistributionAndOrderingUtils$();
    }

    public LogicalPlan prepareQuery(Write write, LogicalPlan query, SQLConf conf) {
        LogicalPlan logicalPlan2;
        Write write2 = write;
        if (write2 instanceof RequiresDistributionAndOrdering) {
            LogicalPlan queryWithDistributionAndOrdering;
            LogicalPlan logicalPlan3;
            Seq seq;
            RequiresDistributionAndOrdering requiresDistributionAndOrdering = (RequiresDistributionAndOrdering)write2;
            int numPartitions = requiresDistributionAndOrdering.requiredNumPartitions();
            Distribution distribution = requiresDistributionAndOrdering.requiredDistribution();
            if (distribution instanceof OrderedDistribution) {
                OrderedDistribution orderedDistribution = (OrderedDistribution)distribution;
                seq = V2ExpressionUtils$.MODULE$.toCatalystOrdering(orderedDistribution.ordering(), query);
            } else if (distribution instanceof ClusteredDistribution) {
                ClusteredDistribution clusteredDistribution = (ClusteredDistribution)distribution;
                seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])clusteredDistribution.clustering())).map((Function1 & Serializable & scala.Serializable)e -> V2ExpressionUtils$.MODULE$.toCatalyst(e, query, V2ExpressionUtils$.MODULE$.toCatalyst$default$3()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class))))).toSeq();
            } else if (distribution instanceof UnspecifiedDistribution) {
                seq = (Seq)Nil$.MODULE$;
            } else {
                throw new MatchError((Object)distribution);
            }
            Seq distribution2 = seq;
            if (distribution2.nonEmpty()) {
                int finalNumPartitions = numPartitions > 0 ? numPartitions : conf.numShufflePartitions();
                logicalPlan3 = RepartitionByExpression$.MODULE$.apply(distribution2, query, finalNumPartitions);
            } else {
                if (numPartitions > 0) {
                    throw QueryCompilationErrors$.MODULE$.numberOfPartitionsNotAllowedWithUnspecifiedDistributionError();
                }
                logicalPlan3 = query;
            }
            LogicalPlan queryWithDistribution = logicalPlan3;
            Seq ordering = V2ExpressionUtils$.MODULE$.toCatalystOrdering(requiresDistributionAndOrdering.requiredOrdering(), query);
            logicalPlan2 = queryWithDistributionAndOrdering = ordering.nonEmpty() ? new Sort(ordering, false, queryWithDistribution) : queryWithDistribution;
        } else {
            logicalPlan2 = query;
        }
        return logicalPlan2;
    }

    private DistributionAndOrderingUtils$() {
        MODULE$ = this;
    }
}

