/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;

public class ParquetFooterReader {
    public static ParquetMetadata readFooter(Configuration configuration, Path file, ParquetMetadataConverter.MetadataFilter filter) throws IOException {
        return ParquetFooterReader.readFooter(HadoopInputFile.fromPath((Path)file, (Configuration)configuration), filter);
    }

    public static ParquetMetadata readFooter(Configuration configuration, FileStatus fileStatus, ParquetMetadataConverter.MetadataFilter filter) throws IOException {
        return ParquetFooterReader.readFooter(HadoopInputFile.fromStatus((FileStatus)fileStatus, (Configuration)configuration), filter);
    }

    private static ParquetMetadata readFooter(HadoopInputFile inputFile, ParquetMetadataConverter.MetadataFilter filter) throws IOException {
        ParquetReadOptions readOptions = HadoopReadOptions.builder((Configuration)inputFile.getConfiguration(), (Path)inputFile.getPath()).withMetadataFilter(filter).build();
        try (ParquetFileReader fileReader = ParquetFileReader.open((InputFile)inputFile, (ParquetReadOptions)readOptions);){
            ParquetMetadata parquetMetadata = fileReader.getFooter();
            return parquetMetadata;
        }
    }
}

