/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.net.URI;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.command.AlterTableSetLocationCommand$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.util.PartitioningUtils$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005-g\u0001\u0002\u000e\u001c\u0001\"B\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0005\"Aq\t\u0001BK\u0002\u0013\u0005\u0001\n\u0003\u0005e\u0001\tE\t\u0015!\u0003J\u0011!)\u0007A!f\u0001\n\u00031\u0007\u0002C8\u0001\u0005#\u0005\u000b\u0011B4\t\u000bA\u0004A\u0011A9\t\u000bY\u0004A\u0011I<\t\u0013\u0005U\u0001!!A\u0005\u0002\u0005]\u0001\"CA\u0010\u0001E\u0005I\u0011AA\u0011\u0011%\t9\u0004AI\u0001\n\u0003\tI\u0004C\u0005\u0002>\u0001\t\n\u0011\"\u0001\u0002@!I\u00111\t\u0001\u0002\u0002\u0013\u0005\u0013Q\t\u0005\n\u0003+\u0002\u0011\u0011!C\u0001\u0003/B\u0011\"a\u0018\u0001\u0003\u0003%\t!!\u0019\t\u0013\u00055\u0004!!A\u0005B\u0005=\u0004\"CA?\u0001\u0005\u0005I\u0011AA@\u0011%\tI\tAA\u0001\n\u0003\nYiB\u0005\u0002\u0010n\t\t\u0011#\u0001\u0002\u0012\u001aA!dGA\u0001\u0012\u0003\t\u0019\n\u0003\u0004q)\u0011\u0005\u0011\u0011\u0015\u0005\n\u0003G#\u0012\u0011!C#\u0003KC\u0011\"a*\u0015\u0003\u0003%\t)!+\t\u0013\u0005EF#!A\u0005\u0002\u0006M\u0006\"CAa)\u0005\u0005I\u0011BAb\u0005q\tE\u000e^3s)\u0006\u0014G.Z*fi2{7-\u0019;j_:\u001cu.\\7b]\u0012T!\u0001H\u000f\u0002\u000f\r|W.\\1oI*\u0011adH\u0001\nKb,7-\u001e;j_:T!\u0001I\u0011\u0002\u0007M\fHN\u0003\u0002#G\u0005)1\u000f]1sW*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u00154ou\u0002\"AK\u0019\u000e\u0003-R!\u0001L\u0017\u0002\u000f1|w-[2bY*\u0011afL\u0001\u0006a2\fgn\u001d\u0006\u0003a}\t\u0001bY1uC2L8\u000f^\u0005\u0003e-\u00121\u0002T8hS\u000e\fG\u000e\u00157b]B\u0011A'N\u0007\u00027%\u0011ag\u0007\u0002\u0014\u0019\u0016\fgMU;o]\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\b!J|G-^2u!\tAd(\u0003\u0002@s\ta1+\u001a:jC2L'0\u00192mK\u0006IA/\u00192mK:\u000bW.Z\u000b\u0002\u0005B\u00111\tR\u0007\u0002_%\u0011Qi\f\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\u0006QA/\u00192mK:\u000bW.\u001a\u0011\u0002\u001bA\f'\u000f^5uS>t7\u000b]3d+\u0005I\u0005c\u0001\u001dK\u0019&\u00111*\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00055\u000bgB\u0001(_\u001d\tyEL\u0004\u0002Q7:\u0011\u0011K\u0017\b\u0003%fs!a\u0015-\u000f\u0005Q;V\"A+\u000b\u0005Y;\u0013A\u0002\u001fs_>$h(C\u0001'\u0013\t!S%\u0003\u0002#G%\u0011\u0001%I\u0005\u0003a}I!!X\u0018\u0002\u000f\r\fG/\u00197pO&\u0011q\fY\u0001\r\u0007\u0006$\u0018\r\\8h)f\u0004Xm\u001d\u0006\u0003;>J!AY2\u0003%Q\u000b'\r\\3QCJ$\u0018\u000e^5p]N\u0003Xm\u0019\u0006\u0003?\u0002\fa\u0002]1si&$\u0018n\u001c8Ta\u0016\u001c\u0007%\u0001\u0005m_\u000e\fG/[8o+\u00059\u0007C\u00015m\u001d\tI'\u000e\u0005\u0002Us%\u00111.O\u0001\u0007!J,G-\u001a4\n\u00055t'AB*ue&twM\u0003\u0002ls\u0005IAn\\2bi&|g\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tI\u001cH/\u001e\t\u0003i\u0001AQ\u0001Q\u0004A\u0002\tCQaR\u0004A\u0002%CQ!Z\u0004A\u0002\u001d\f1A];o)\rA\u00181\u0002\t\u0005sz\f\u0019A\u0004\u0002{y:\u0011Ak_\u0005\u0002u%\u0011Q0O\u0001\ba\u0006\u001c7.Y4f\u0013\ry\u0018\u0011\u0001\u0002\u0004'\u0016\f(BA?:!\u0011\t)!a\u0002\u000e\u0003}I1!!\u0003 \u0005\r\u0011vn\u001e\u0005\b\u0003\u001bA\u0001\u0019AA\b\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\u0011\t)!!\u0005\n\u0007\u0005MqD\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0003d_BLHc\u0002:\u0002\u001a\u0005m\u0011Q\u0004\u0005\b\u0001&\u0001\n\u00111\u0001C\u0011\u001d9\u0015\u0002%AA\u0002%Cq!Z\u0005\u0011\u0002\u0003\u0007q-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\r\"f\u0001\"\u0002&-\u0012\u0011q\u0005\t\u0005\u0003S\t\u0019$\u0004\u0002\u0002,)!\u0011QFA\u0018\u0003%)hn\u00195fG.,GMC\u0002\u00022e\n!\"\u00198o_R\fG/[8o\u0013\u0011\t)$a\u000b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005m\"fA%\u0002&\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA!U\r9\u0017QE\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u001d\u0003\u0003BA%\u0003'j!!a\u0013\u000b\t\u00055\u0013qJ\u0001\u0005Y\u0006twM\u0003\u0002\u0002R\u0005!!.\u0019<b\u0013\ri\u00171J\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u00033\u00022\u0001OA.\u0013\r\ti&\u000f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003G\nI\u0007E\u00029\u0003KJ1!a\u001a:\u0005\r\te.\u001f\u0005\n\u0003Wz\u0011\u0011!a\u0001\u00033\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA9!\u0019\t\u0019(!\u001f\u0002d5\u0011\u0011Q\u000f\u0006\u0004\u0003oJ\u0014AC2pY2,7\r^5p]&!\u00111PA;\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u0005\u0015q\u0011\t\u0004q\u0005\r\u0015bAACs\t9!i\\8mK\u0006t\u0007\"CA6#\u0005\u0005\t\u0019AA2\u0003\u0019)\u0017/^1mgR!\u0011\u0011QAG\u0011%\tYGEA\u0001\u0002\u0004\t\u0019'\u0001\u000fBYR,'\u000fV1cY\u0016\u001cV\r\u001e'pG\u0006$\u0018n\u001c8D_6l\u0017M\u001c3\u0011\u0005Q\"2\u0003\u0002\u000b\u0002\u0016v\u0002\u0002\"a&\u0002\u001e\nKuM]\u0007\u0003\u00033S1!a':\u0003\u001d\u0011XO\u001c;j[\u0016LA!a(\u0002\u001a\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\u0005E\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u001d\u0013!B1qa2LHc\u0002:\u0002,\u00065\u0016q\u0016\u0005\u0006\u0001^\u0001\rA\u0011\u0005\u0006\u000f^\u0001\r!\u0013\u0005\u0006K^\u0001\raZ\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t),!0\u0011\taR\u0015q\u0017\t\u0007q\u0005e&)S4\n\u0007\u0005m\u0016H\u0001\u0004UkBdWm\r\u0005\t\u0003\u007fC\u0012\u0011!a\u0001e\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u000b\u0004B!!\u0013\u0002H&!\u0011\u0011ZA&\u0005\u0019y%M[3di\u0002")
public class AlterTableSetLocationCommand
extends LogicalPlan
implements LeafRunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final Option<Map<String, String>> partitionSpec;
    private final String location;
    private Map<String, SQLMetric> metrics;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, Option<Map<String, String>>, String>> unapply(AlterTableSetLocationCommand alterTableSetLocationCommand) {
        return AlterTableSetLocationCommand$.MODULE$.unapply(alterTableSetLocationCommand);
    }

    public static Function1<Tuple3<TableIdentifier, Option<Map<String, String>>, String>, AlterTableSetLocationCommand> tupled() {
        return AlterTableSetLocationCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Option<Map<String, String>>, Function1<String, AlterTableSetLocationCommand>>> curried() {
        return AlterTableSetLocationCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableSetLocationCommand alterTableSetLocationCommand = this;
        synchronized (alterTableSetLocationCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public Option<Map<String, String>> partitionSpec() {
        return this.partitionSpec;
    }

    public String location() {
        return this.location;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable table = catalog.getTableMetadata(this.tableName());
        URI locUri = CatalogUtils$.MODULE$.stringToURI(this.location());
        Option<Map<String, String>> option = this.partitionSpec();
        if (option instanceof Some) {
            Some some = (Some)option;
            Map spec = (Map)some.value();
            DDLUtils$.MODULE$.verifyPartitionProviderIsHive(sparkSession, table, "ALTER TABLE ... SET LOCATION");
            Map normalizedSpec = PartitioningUtils$.MODULE$.normalizePartitionSpec(spec, table.partitionSchema(), table.identifier().quotedString(), sparkSession.sessionState().conf().resolver());
            CatalogTablePartition part = catalog.getPartition(table.identifier(), normalizedSpec);
            CatalogStorageFormat x$1 = part.storage().copy((Option)new Some((Object)locUri), part.storage().copy$default$2(), part.storage().copy$default$3(), part.storage().copy$default$4(), part.storage().copy$default$5(), part.storage().copy$default$6());
            Map x$2 = part.copy$default$1();
            Map x$3 = part.copy$default$3();
            long x$4 = part.copy$default$4();
            long x$5 = part.copy$default$5();
            Option x$6 = part.copy$default$6();
            CatalogTablePartition newPart = part.copy(x$2, x$1, x$3, x$4, x$5, x$6);
            catalog.alterPartitions(table.identifier(), (Seq)new .colon.colon((Object)newPart, (List)Nil$.MODULE$));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            catalog.alterTable(table.withNewStorage((Option)new Some((Object)locUri), table.withNewStorage$default$2(), table.withNewStorage$default$3(), table.withNewStorage$default$4(), table.withNewStorage$default$5(), table.withNewStorage$default$6()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        sparkSession.catalog().refreshTable(table.identifier().quotedString());
        CommandUtils$.MODULE$.updateTableStats(sparkSession, table);
        return (Seq)Nil$.MODULE$;
    }

    public AlterTableSetLocationCommand copy(TableIdentifier tableName, Option<Map<String, String>> partitionSpec, String location) {
        return new AlterTableSetLocationCommand(tableName, partitionSpec, location);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public Option<Map<String, String>> copy$default$2() {
        return this.partitionSpec();
    }

    public String copy$default$3() {
        return this.location();
    }

    public String productPrefix() {
        return "AlterTableSetLocationCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableName();
                break;
            }
            case 1: {
                object = this.partitionSpec();
                break;
            }
            case 2: {
                object = this.location();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableSetLocationCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableSetLocationCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableSetLocationCommand alterTableSetLocationCommand = (AlterTableSetLocationCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = alterTableSetLocationCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Option<Map<String, String>> option = this.partitionSpec();
        Option<Map<String, String>> option2 = alterTableSetLocationCommand.partitionSpec();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        String string = this.location();
        String string2 = alterTableSetLocationCommand.location();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!alterTableSetLocationCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableSetLocationCommand(TableIdentifier tableName, Option<Map<String, String>> partitionSpec, String location) {
        this.tableName = tableName;
        this.partitionSpec = partitionSpec;
        this.location = location;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
    }
}

