/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.AuthInfo;
import io.fabric8.kubernetes.api.model.AuthInfoBuilder;
import io.fabric8.kubernetes.api.model.AuthInfoFluent;
import io.fabric8.kubernetes.api.model.NamedAuthInfo;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NamedAuthInfoFluent<A extends NamedAuthInfoFluent<A>>
extends BaseFluent<A> {
    private String name;
    private AuthInfoBuilder user;
    private Map<String, Object> additionalProperties;

    public NamedAuthInfoFluent() {
    }

    public NamedAuthInfoFluent(NamedAuthInfo instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NamedAuthInfo instance) {
        NamedAuthInfo namedAuthInfo = instance = instance != null ? instance : new NamedAuthInfo();
        if (instance != null) {
            this.withName(instance.getName());
            this.withUser(instance.getUser());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public AuthInfo buildUser() {
        return this.user != null ? this.user.build() : null;
    }

    public A withUser(AuthInfo user) {
        this._visitables.remove((Object)"user");
        if (user != null) {
            this.user = new AuthInfoBuilder(user);
            this._visitables.get((Object)"user").add(this.user);
        } else {
            this.user = null;
            this._visitables.get((Object)"user").remove((Object)this.user);
        }
        return (A)((Object)this);
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public UserNested<A> withNewUser() {
        return new UserNested(null);
    }

    public UserNested<A> withNewUserLike(AuthInfo item) {
        return new UserNested(item);
    }

    public UserNested<A> editUser() {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(null));
    }

    public UserNested<A> editOrNewUser() {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(new AuthInfoBuilder().build()));
    }

    public UserNested<A> editOrNewUserLike(AuthInfo item) {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedAuthInfoFluent that = (NamedAuthInfoFluent)((Object)o);
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals((Object)this.user, (Object)that.user)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.user, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.user != null) {
            sb.append("user:");
            sb.append((Object)((Object)this.user) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UserNested<N>
    extends AuthInfoFluent<UserNested<N>>
    implements Nested<N> {
        AuthInfoBuilder builder;

        UserNested(AuthInfo item) {
            this.builder = new AuthInfoBuilder(this, item);
        }

        public N and() {
            return (N)NamedAuthInfoFluent.this.withUser(this.builder.build());
        }

        public N endUser() {
            return this.and();
        }
    }
}

