/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.table;

import java.util.Map;
import org.apache.amoro.TableFormat;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.table.TableBuilder;
import org.apache.amoro.table.TableIdentifier;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;

public abstract class BasicTableBuilder<ThisT extends TableBuilder>
implements TableBuilder {
    protected PartitionSpec spec = PartitionSpec.unpartitioned();
    protected SortOrder sortOrder = SortOrder.unsorted();
    protected Map<String, String> properties = Maps.newHashMap();
    protected PrimaryKeySpec keySpec = PrimaryKeySpec.noPrimaryKey();
    protected final Schema schema;
    protected final TableIdentifier identifier;
    protected final TableFormat format;

    public BasicTableBuilder(Schema schema, TableFormat format, TableIdentifier identifier) {
        this.schema = schema;
        this.format = format;
        this.identifier = identifier;
    }

    @Override
    public TableBuilder withPartitionSpec(PartitionSpec partitionSpec) {
        this.spec = partitionSpec;
        return this.self();
    }

    @Override
    public TableBuilder withSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        return this.self();
    }

    @Override
    public TableBuilder withProperties(Map<String, String> properties) {
        Preconditions.checkNotNull(properties, (Object)"table properties must not be null");
        this.properties = properties;
        return this.self();
    }

    @Override
    public TableBuilder withProperty(String key, String value) {
        this.properties.put(key, value);
        return this.self();
    }

    @Override
    public TableBuilder withPrimaryKeySpec(PrimaryKeySpec primaryKeySpec) {
        this.keySpec = primaryKeySpec;
        return this.self();
    }

    protected abstract ThisT self();
}

