/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.op;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.table.KeyedTable;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.UpdateProperties;

public class UpdateKeyedTableProperties
implements UpdateProperties {
    private final Map<String, String> propsSet = Maps.newHashMap();
    private final Set<String> propsDel = Sets.newHashSet();
    private final KeyedTable keyedTable;

    public UpdateKeyedTableProperties(KeyedTable keyedTable) {
        this.keyedTable = keyedTable;
    }

    public UpdateProperties set(String key, String value) {
        this.propsSet.put(key, value);
        return this;
    }

    public UpdateProperties remove(String key) {
        this.propsDel.add(key);
        return this;
    }

    public UpdateProperties defaultFormat(FileFormat format) {
        this.set("write.format.default", format.name());
        return this;
    }

    public Map<String, String> apply() {
        HashMap newProperties = Maps.newHashMap();
        for (Map.Entry<String, String> entry : this.keyedTable.properties().entrySet()) {
            if (this.propsDel.contains(entry.getKey())) continue;
            newProperties.put(entry.getKey(), entry.getValue());
        }
        newProperties.putAll(this.propsSet);
        return newProperties;
    }

    public void commit() {
        Object props = this.apply();
        this.commitIcebergTableProperties(this.keyedTable.baseTable());
        if (this.keyedTable.changeTable() != null) {
            this.commitIcebergTableProperties(this.keyedTable.changeTable());
        }
    }

    protected void commitIcebergTableProperties(UnkeyedTable unkeyedTable) {
        UpdateProperties updateProperties = unkeyedTable.updateProperties();
        this.propsSet.forEach((arg_0, arg_1) -> ((UpdateProperties)updateProperties).set(arg_0, arg_1));
        this.propsDel.forEach(arg_0 -> ((UpdateProperties)updateProperties).remove(arg_0));
        updateProperties.commit();
    }
}

