/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.terminal;

import java.util.ArrayList;
import java.util.List;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;

public class StatementResult {
    private final int lineNumber;
    private final String statement;
    private boolean success;
    private String logs;
    private final List<String> columns;
    private final List<Object[]> datas = Lists.newArrayList();
    private final boolean empty;

    public StatementResult(String statement, int lineNumber, List<String> columns) {
        this.statement = statement;
        this.lineNumber = lineNumber;
        this.columns = columns;
        this.success = true;
        this.empty = false;
    }

    public void appendRow(Object[] row) {
        this.datas.add(row);
    }

    public void withExceptionLog(String log) {
        this.logs = log;
        this.success = false;
    }

    public String getStatement() {
        return this.statement;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getLogs() {
        return this.logs;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<Object[]> getDatas() {
        return this.datas;
    }

    public List<List<String>> getDataAsStringList() {
        ArrayList results = Lists.newArrayList();
        for (Object[] row : this.datas) {
            ArrayList rowStringList = Lists.newArrayList();
            for (Object o : row) {
                if (o == null) {
                    rowStringList.add("null");
                    continue;
                }
                rowStringList.add(o.toString());
            }
            results.add(rowStringList);
        }
        return results;
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

