/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.persistence.mapper;

import java.util.List;
import org.apache.amoro.server.persistence.converter.Long2TsConverter;
import org.apache.amoro.server.persistence.converter.Map2StringConverter;
import org.apache.amoro.server.resource.OptimizerInstance;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

@Mapper
public interface OptimizerMapper {
    @Insert(value={"INSERT INTO optimizer (token, resource_id, group_name,container_name, start_time, touch_time, thread_count, total_memory, properties) VALUES (#{optimizer.token}, #{optimizer.resourceId, jdbcType=VARCHAR}, #{optimizer.groupName}, #{optimizer.containerName}, #{optimizer.startTime, typeHandler=org.apache.amoro.server.persistence.converter.Long2TsConverter}, #{optimizer.touchTime, typeHandler=org.apache.amoro.server.persistence.converter.Long2TsConverter}, #{optimizer.threadCount}, #{optimizer.memoryMb}, #{optimizer.properties, typeHandler=org.apache.amoro.server.persistence.converter.Map2StringConverter})"})
    public void insertOptimizer(@Param(value="optimizer") OptimizerInstance var1);

    @Update(value={"UPDATE optimizer SET touch_time = CURRENT_TIMESTAMP WHERE token = #{token}"})
    public void updateTouchTime(@Param(value="token") String var1);

    @Delete(value={"DELETE FROM optimizer WHERE token = #{token}"})
    public void deleteOptimizer(@Param(value="token") String var1);

    @Select(value={"SELECT token, resource_id, group_name, container_name, start_time, touch_time,thread_count, total_memory, properties FROM optimizer"})
    @Results(value={@Result(property="token", column="token"), @Result(property="resourceId", column="resource_id"), @Result(property="groupName", column="group_name"), @Result(property="containerName", column="container_name"), @Result(property="startTime", column="start_time", typeHandler=Long2TsConverter.class), @Result(property="touchTime", column="touch_time", typeHandler=Long2TsConverter.class), @Result(property="threadCount", column="thread_count"), @Result(property="memoryMb", column="total_memory"), @Result(property="properties", column="properties", typeHandler=Map2StringConverter.class)})
    public List<OptimizerInstance> selectAll();

    @Select(value={"SELECT token, resource_id, group_name, container_name, start_time, touch_time,thread_count, total_memory, properties FROM optimizer WHERE resource_id = #{resourceId}"})
    @Results(value={@Result(property="token", column="token"), @Result(property="resourceId", column="resource_id"), @Result(property="groupName", column="group_name"), @Result(property="containerName", column="container_name"), @Result(property="startTime", column="start_time", typeHandler=Long2TsConverter.class), @Result(property="touchTime", column="touch_time", typeHandler=Long2TsConverter.class), @Result(property="threadCount", column="thread_count"), @Result(property="memoryMb", column="total_memory"), @Result(property="properties", column="properties", typeHandler=Map2StringConverter.class)})
    public List<OptimizerInstance> selectByResourceId(@Param(value="resourceId") String var1);
}

