/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import org.apache.iceberg.ChangelogScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PositionDeletesScanTask;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.source.ChangelogRowReader;
import org.apache.iceberg.spark.source.PositionDeletesRowReader;
import org.apache.iceberg.spark.source.RowDataReader;
import org.apache.iceberg.spark.source.SparkInputPartition;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.vectorized.ColumnarBatch;

class SparkRowReaderFactory
implements PartitionReaderFactory {
    SparkRowReaderFactory() {
    }

    public PartitionReader<InternalRow> createReader(InputPartition inputPartition) {
        Preconditions.checkArgument((boolean)(inputPartition instanceof SparkInputPartition), (String)"Unknown input partition type: %s", (Object)inputPartition.getClass().getName());
        SparkInputPartition partition = (SparkInputPartition)inputPartition;
        if (partition.allTasksOfType(FileScanTask.class)) {
            return new RowDataReader(partition);
        }
        if (partition.allTasksOfType(ChangelogScanTask.class)) {
            return new ChangelogRowReader(partition);
        }
        if (partition.allTasksOfType(PositionDeletesScanTask.class)) {
            return new PositionDeletesRowReader(partition);
        }
        throw new UnsupportedOperationException("Unsupported task group for row-based reads: " + partition.taskGroup());
    }

    public PartitionReader<ColumnarBatch> createColumnarReader(InputPartition inputPartition) {
        throw new UnsupportedOperationException("Columnar reads are not supported");
    }

    public boolean supportColumnarReads(InputPartition inputPartition) {
        return false;
    }
}

