/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data.vectorized;

import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.types.Type;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.types.UTF8String;

public class DeletedColumnVector
extends ColumnVector {
    private final boolean[] isDeleted;

    public DeletedColumnVector(Type type, boolean[] isDeleted) {
        super(SparkSchemaUtil.convert(type));
        Preconditions.checkArgument((isDeleted != null ? 1 : 0) != 0, (Object)"Boolean array isDeleted cannot be null");
        this.isDeleted = isDeleted;
    }

    public void close() {
    }

    public boolean hasNull() {
        return false;
    }

    public int numNulls() {
        return 0;
    }

    public boolean isNullAt(int rowId) {
        return false;
    }

    public boolean getBoolean(int rowId) {
        return this.isDeleted[rowId];
    }

    public byte getByte(int rowId) {
        throw new UnsupportedOperationException();
    }

    public short getShort(int rowId) {
        throw new UnsupportedOperationException();
    }

    public int getInt(int rowId) {
        throw new UnsupportedOperationException();
    }

    public long getLong(int rowId) {
        throw new UnsupportedOperationException();
    }

    public float getFloat(int rowId) {
        throw new UnsupportedOperationException();
    }

    public double getDouble(int rowId) {
        throw new UnsupportedOperationException();
    }

    public ColumnarArray getArray(int rowId) {
        throw new UnsupportedOperationException();
    }

    public ColumnarMap getMap(int ordinal) {
        throw new UnsupportedOperationException();
    }

    public Decimal getDecimal(int rowId, int precision, int scale) {
        throw new UnsupportedOperationException();
    }

    public UTF8String getUTF8String(int rowId) {
        throw new UnsupportedOperationException();
    }

    public byte[] getBinary(int rowId) {
        throw new UnsupportedOperationException();
    }

    public ColumnVector getChild(int ordinal) {
        throw new UnsupportedOperationException();
    }
}

