/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.source.coordinator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.api.connector.source.SplitsAssignment;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.runtime.source.coordinator.SourceCoordinatorSerdeUtils;

@Internal
public class SplitAssignmentTracker<SplitT extends SourceSplit> {
    private final SortedMap<Long, Map<Integer, LinkedHashSet<SplitT>>> assignmentsByCheckpointId = new TreeMap<Long, Map<Integer, LinkedHashSet<SplitT>>>();
    private Map<Integer, LinkedHashSet<SplitT>> uncheckpointedAssignments = new HashMap<Integer, LinkedHashSet<SplitT>>();

    public void onCheckpoint(long checkpointId) throws Exception {
        this.assignmentsByCheckpointId.put(checkpointId, this.uncheckpointedAssignments);
        this.uncheckpointedAssignments = new HashMap<Integer, LinkedHashSet<SplitT>>();
    }

    public byte[] snapshotState(SimpleVersionedSerializer<SplitT> splitSerializer) throws Exception {
        return SourceCoordinatorSerdeUtils.serializeAssignments(this.uncheckpointedAssignments, splitSerializer);
    }

    public void restoreState(SimpleVersionedSerializer<SplitT> splitSerializer, byte[] assignmentData) throws Exception {
        this.uncheckpointedAssignments = SourceCoordinatorSerdeUtils.deserializeAssignments(assignmentData, splitSerializer);
    }

    public void onCheckpointComplete(long checkpointId) {
        this.assignmentsByCheckpointId.entrySet().removeIf(entry -> (Long)entry.getKey() <= checkpointId);
    }

    public void recordSplitAssignment(SplitsAssignment<SplitT> splitsAssignment) {
        this.addSplitAssignment(splitsAssignment, this.uncheckpointedAssignments);
    }

    public List<SplitT> getAndRemoveUncheckpointedAssignment(int subtaskId, long restoredCheckpointId) {
        ArrayList splits = new ArrayList();
        for (Map.Entry<Long, Map<Integer, LinkedHashSet<SplitT>>> entry : this.assignmentsByCheckpointId.entrySet()) {
            if (entry.getKey() <= restoredCheckpointId) continue;
            this.removeFromAssignment(subtaskId, entry.getValue(), splits);
        }
        this.removeFromAssignment(subtaskId, this.uncheckpointedAssignments, splits);
        return splits;
    }

    @VisibleForTesting
    SortedMap<Long, Map<Integer, LinkedHashSet<SplitT>>> assignmentsByCheckpointId() {
        return this.assignmentsByCheckpointId;
    }

    @VisibleForTesting
    Map<Integer, LinkedHashSet<SplitT>> assignmentsByCheckpointId(long checkpointId) {
        return (Map)this.assignmentsByCheckpointId.get(checkpointId);
    }

    Map<Integer, LinkedHashSet<SplitT>> uncheckpointedAssignments() {
        return Collections.unmodifiableMap(this.uncheckpointedAssignments);
    }

    private void removeFromAssignment(int subtaskId, Map<Integer, LinkedHashSet<SplitT>> assignments, List<SplitT> toPutBack) {
        Set splitForSubtask = assignments.remove(subtaskId);
        if (splitForSubtask != null) {
            toPutBack.addAll(splitForSubtask);
        }
    }

    private void addSplitAssignment(SplitsAssignment<SplitT> additionalAssignment, Map<Integer, LinkedHashSet<SplitT>> assignments) {
        additionalAssignment.assignment().forEach((id, splits) -> assignments.computeIfAbsent((Integer)id, ignored -> new LinkedHashSet()).addAll(splits));
    }
}

