/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.messages.AggregatedTaskDetailsInfo;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptDetailsInfo;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDDeserializer;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.util.Preconditions;

public class JobVertexDetailsInfo
implements ResponseBody {
    public static final String FIELD_NAME_VERTEX_ID = "id";
    public static final String FIELD_NAME_VERTEX_NAME = "name";
    public static final String FIELD_NAME_PARALLELISM = "parallelism";
    public static final String FIELD_NAME_MAX_PARALLELISM = "maxParallelism";
    public static final String FIELD_NAME_NOW = "now";
    public static final String FIELD_NAME_SUBTASKS = "subtasks";
    public static final String FIELD_NAME_AGGREGATED = "aggregated";
    @JsonProperty(value="id")
    @JsonSerialize(using=JobVertexIDSerializer.class)
    private final JobVertexID id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="parallelism")
    private final int parallelism;
    @JsonProperty(value="maxParallelism")
    private final int maxParallelism;
    @JsonProperty(value="now")
    private final long now;
    @JsonProperty(value="subtasks")
    private final List<SubtaskExecutionAttemptDetailsInfo> subtasks;
    @JsonProperty(value="aggregated")
    private final AggregatedTaskDetailsInfo aggregated;

    @JsonCreator
    public JobVertexDetailsInfo(@JsonDeserialize(using=JobVertexIDDeserializer.class) @JsonProperty(value="id") JobVertexID id, @JsonProperty(value="name") String name, @JsonProperty(value="parallelism") int parallelism, @JsonProperty(value="maxParallelism") int maxParallelism, @JsonProperty(value="now") long now, @JsonProperty(value="subtasks") List<SubtaskExecutionAttemptDetailsInfo> subtasks) {
        this.id = (JobVertexID)Preconditions.checkNotNull((Object)id);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.parallelism = parallelism;
        this.maxParallelism = maxParallelism;
        this.now = now;
        this.subtasks = (List)Preconditions.checkNotNull(subtasks);
        this.aggregated = AggregatedTaskDetailsInfo.create(subtasks);
    }

    @JsonIgnore
    public List<SubtaskExecutionAttemptDetailsInfo> getSubtasks() {
        return Collections.unmodifiableList(this.subtasks);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        JobVertexDetailsInfo that = (JobVertexDetailsInfo)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && this.parallelism == that.parallelism && this.maxParallelism == that.maxParallelism && this.now == that.now && Objects.equals(this.subtasks, that.subtasks) && Objects.equals(this.aggregated, that.aggregated);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.parallelism, this.maxParallelism, this.now, this.subtasks, this.aggregated);
    }
}

