/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.metrics;

import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.metrics.AbstractBuffersUsageGauge;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.util.Preconditions;

public class FloatingBuffersUsageGauge
extends AbstractBuffersUsageGauge {
    public FloatingBuffersUsageGauge(SingleInputGate[] inputGates) {
        super((SingleInputGate[])Preconditions.checkNotNull((Object)inputGates));
    }

    @Override
    public int calculateUsedBuffers(SingleInputGate inputGate) {
        int availableFloatingBuffers = 0;
        BufferPool bufferPool = inputGate.getBufferPool();
        if (bufferPool != null) {
            int requestedFloatingBuffers = bufferPool.bestEffortGetNumOfUsedBuffers();
            for (InputChannel ic : inputGate.inputChannels()) {
                if (!(ic instanceof RemoteInputChannel)) continue;
                availableFloatingBuffers += ((RemoteInputChannel)ic).unsynchronizedGetFloatingBuffersAvailable();
            }
            return Math.max(0, requestedFloatingBuffers - availableFloatingBuffers);
        }
        return 0;
    }

    @Override
    public int calculateTotalBuffers(SingleInputGate inputGate) {
        BufferPool bufferPool = inputGate.getBufferPool();
        if (bufferPool != null) {
            return inputGate.getBufferPool().getNumBuffers();
        }
        return 0;
    }
}

