/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;
import org.apache.flink.runtime.highavailability.FileSystemJobResultStore;

@PublicEvolving
public class JobResultStoreOptions {
    @Documentation.Section(value={"common_high_availability_jrs"})
    public static final ConfigOption<String> STORAGE_PATH = ConfigOptions.key((String)"job-result-store.storage-path").stringType().noDefaultValue().withDescription(Description.builder().text("Defines where job results should be stored. This should be an underlying file-system that provides read-after-write consistency. By default, this is %s.", new InlineElement[]{TextElement.code((String)FileSystemJobResultStore.createDefaultJobResultStorePath(String.format("{%s}", HighAvailabilityOptions.HA_STORAGE_PATH.key()), String.format("{%s}", HighAvailabilityOptions.HA_CLUSTER_ID.key())))}).build());
    @Documentation.Section(value={"common_high_availability_jrs"})
    public static final ConfigOption<Boolean> DELETE_ON_COMMIT = ConfigOptions.key((String)"job-result-store.delete-on-commit").booleanType().defaultValue((Object)Boolean.TRUE).withDescription("Determines whether job results should be automatically removed from the underlying job result store when the corresponding entity transitions into a clean state. If false, the cleaned job results are, instead, marked as clean to indicate their state. In this case, Flink no longer has ownership and the resources need to be cleaned up by the user.");
}

