/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover;

import java.time.Duration;
import java.util.Optional;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.apache.flink.runtime.executiongraph.failover.ExponentialDelayRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.FailureRateRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.FixedDelayRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.NoRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.RestartBackoffTimeStrategy;
import org.apache.flink.util.Preconditions;

public final class RestartBackoffTimeStrategyFactoryLoader {
    private RestartBackoffTimeStrategyFactoryLoader() {
    }

    public static RestartBackoffTimeStrategy.Factory createRestartBackoffTimeStrategyFactory(RestartStrategies.RestartStrategyConfiguration jobRestartStrategyConfiguration, Configuration jobConfiguration, Configuration clusterConfiguration, boolean isCheckpointingEnabled) {
        Preconditions.checkNotNull((Object)jobRestartStrategyConfiguration);
        Preconditions.checkNotNull((Object)jobConfiguration);
        Preconditions.checkNotNull((Object)clusterConfiguration);
        return RestartBackoffTimeStrategyFactoryLoader.getJobRestartStrategyFactory(jobRestartStrategyConfiguration).orElse(RestartBackoffTimeStrategyFactoryLoader.getRestartStrategyFactoryFromConfig(jobConfiguration).orElse(RestartBackoffTimeStrategyFactoryLoader.getRestartStrategyFactoryFromConfig(clusterConfiguration).orElse(RestartBackoffTimeStrategyFactoryLoader.getDefaultRestartStrategyFactory(isCheckpointingEnabled))));
    }

    private static Optional<RestartBackoffTimeStrategy.Factory> getJobRestartStrategyFactory(RestartStrategies.RestartStrategyConfiguration restartStrategyConfiguration) {
        if (restartStrategyConfiguration instanceof RestartStrategies.NoRestartStrategyConfiguration) {
            return Optional.of(NoRestartBackoffTimeStrategy.NoRestartBackoffTimeStrategyFactory.INSTANCE);
        }
        if (restartStrategyConfiguration instanceof RestartStrategies.FixedDelayRestartStrategyConfiguration) {
            RestartStrategies.FixedDelayRestartStrategyConfiguration fixedDelayConfig = (RestartStrategies.FixedDelayRestartStrategyConfiguration)restartStrategyConfiguration;
            return Optional.of(new FixedDelayRestartBackoffTimeStrategy.FixedDelayRestartBackoffTimeStrategyFactory(fixedDelayConfig.getRestartAttempts(), fixedDelayConfig.getDurationBetweenAttempts().toMillis()));
        }
        if (restartStrategyConfiguration instanceof RestartStrategies.FailureRateRestartStrategyConfiguration) {
            RestartStrategies.FailureRateRestartStrategyConfiguration failureRateConfig = (RestartStrategies.FailureRateRestartStrategyConfiguration)restartStrategyConfiguration;
            return Optional.of(new FailureRateRestartBackoffTimeStrategy.FailureRateRestartBackoffTimeStrategyFactory(failureRateConfig.getMaxFailureRate(), failureRateConfig.getFailureIntervalDuration().toMillis(), failureRateConfig.getDurationBetweenAttempts().toMillis()));
        }
        if (restartStrategyConfiguration instanceof RestartStrategies.FallbackRestartStrategyConfiguration) {
            return Optional.empty();
        }
        if (restartStrategyConfiguration instanceof RestartStrategies.ExponentialDelayRestartStrategyConfiguration) {
            RestartStrategies.ExponentialDelayRestartStrategyConfiguration exponentialDelayConfig = (RestartStrategies.ExponentialDelayRestartStrategyConfiguration)restartStrategyConfiguration;
            return Optional.of(new ExponentialDelayRestartBackoffTimeStrategy.ExponentialDelayRestartBackoffTimeStrategyFactory(exponentialDelayConfig.getInitialBackoffDuration().toMillis(), exponentialDelayConfig.getMaxBackoffDuration().toMillis(), exponentialDelayConfig.getBackoffMultiplier(), exponentialDelayConfig.getResetBackoffDurationThreshold().toMillis(), exponentialDelayConfig.getJitterFactor(), (Integer)RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_ATTEMPTS.defaultValue()));
        }
        throw new IllegalArgumentException("Unknown restart strategy configuration " + restartStrategyConfiguration + ".");
    }

    private static Optional<RestartBackoffTimeStrategy.Factory> getRestartStrategyFactoryFromConfig(Configuration configuration) {
        Optional restartStrategyNameOptional = configuration.getOptional(RestartStrategyOptions.RESTART_STRATEGY);
        return restartStrategyNameOptional.map(restartStrategyName -> {
            switch (RestartStrategyOptions.RestartStrategyType.of((String)restartStrategyName.toLowerCase())) {
                case NO_RESTART_STRATEGY: {
                    return NoRestartBackoffTimeStrategy.NoRestartBackoffTimeStrategyFactory.INSTANCE;
                }
                case FIXED_DELAY: {
                    return FixedDelayRestartBackoffTimeStrategy.createFactory(configuration);
                }
                case FAILURE_RATE: {
                    return FailureRateRestartBackoffTimeStrategy.createFactory(configuration);
                }
                case EXPONENTIAL_DELAY: {
                    return ExponentialDelayRestartBackoffTimeStrategy.createFactory(configuration);
                }
            }
            throw new IllegalArgumentException("Unknown restart strategy " + restartStrategyName + ".");
        });
    }

    private static RestartBackoffTimeStrategy.Factory getDefaultRestartStrategyFactory(boolean isCheckpointingEnabled) {
        if (isCheckpointingEnabled) {
            return new ExponentialDelayRestartBackoffTimeStrategy.ExponentialDelayRestartBackoffTimeStrategyFactory(((Duration)RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_INITIAL_BACKOFF.defaultValue()).toMillis(), ((Duration)RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_MAX_BACKOFF.defaultValue()).toMillis(), (Double)RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_BACKOFF_MULTIPLIER.defaultValue(), ((Duration)RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_RESET_BACKOFF_THRESHOLD.defaultValue()).toMillis(), (Double)RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_JITTER_FACTOR.defaultValue(), (Integer)RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_ATTEMPTS.defaultValue());
        }
        return NoRestartBackoffTimeStrategy.NoRestartBackoffTimeStrategyFactory.INSTANCE;
    }
}

