/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.s3a.AWSApiCallTimeoutException;
import org.apache.hadoop.fs.s3a.AWSBadRequestException;
import org.apache.hadoop.fs.s3a.AWSClientIOException;
import org.apache.hadoop.fs.s3a.AWSCredentialProviderList;
import org.apache.hadoop.fs.s3a.AWSNoResponseException;
import org.apache.hadoop.fs.s3a.AWSRedirectException;
import org.apache.hadoop.fs.s3a.AWSS3IOException;
import org.apache.hadoop.fs.s3a.AWSServiceIOException;
import org.apache.hadoop.fs.s3a.AWSServiceThrottledException;
import org.apache.hadoop.fs.s3a.AWSStatus500Exception;
import org.apache.hadoop.fs.s3a.AWSUnsupportedFeatureException;
import org.apache.hadoop.fs.s3a.RangeNotSatisfiableEOFException;
import org.apache.hadoop.fs.s3a.RemoteFileChangedException;
import org.apache.hadoop.fs.s3a.S3AEncryptionMethods;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.fs.s3a.UnknownStoreException;
import org.apache.hadoop.fs.s3a.audit.AuditIntegration;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecrets;
import org.apache.hadoop.fs.s3a.impl.ErrorTranslation;
import org.apache.hadoop.fs.s3a.impl.InstantiationIOException;
import org.apache.hadoop.fs.s3a.impl.MultiObjectDeleteException;
import org.apache.hadoop.fs.s3native.S3xLoginHelper;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.ConnectTimeoutException;
import org.apache.hadoop.security.ProviderUtils;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.AbortedException;
import software.amazon.awssdk.core.exception.ApiCallAttemptTimeoutException;
import software.amazon.awssdk.core.exception.ApiCallTimeoutException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.retry.RetryUtils;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class S3AUtils {
    private static final Logger LOG = LoggerFactory.getLogger(S3AUtils.class);
    static final String ENDPOINT_KEY = "Endpoint";
    static final String E_FS_CLOSED = "FileSystem is closed!";
    static final String CREDENTIAL_PROVIDER_PATH = "hadoop.security.credential.provider.path";
    public static final String SSE_C_NO_KEY_ERROR = S3AEncryptionMethods.SSE_C.getMethod() + " is enabled but no encryption key was declared in " + "fs.s3a.encryption.key";
    public static final String SSE_S3_WITH_KEY_ERROR = S3AEncryptionMethods.SSE_S3.getMethod() + " is enabled but an encryption key was set in " + "fs.s3a.encryption.key";
    public static final String EOF_MESSAGE_IN_XML_PARSER = "Failed to sanitize XML document destined for handler class";
    public static final String EOF_READ_DIFFERENT_LENGTH = "Data read has a different length than the expected";
    private static final String BUCKET_PATTERN = "fs.s3a.bucket.%s.%s";
    public static final PathFilter HIDDEN_FILE_FILTER = new PathFilter(){

        public boolean accept(Path path) {
            String name = path.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }

        public String toString() {
            return "HIDDEN_FILE_FILTER";
        }
    };
    public static final PathFilter ACCEPT_ALL = new PathFilter(){

        public boolean accept(Path file) {
            return true;
        }

        public String toString() {
            return "ACCEPT_ALL";
        }
    };

    private S3AUtils() {
    }

    public static IOException translateException(String operation, Path path, SdkException exception) {
        return S3AUtils.translateException(operation, path.toString(), exception);
    }

    public static IOException translateException(@Nullable String operation, @Nullable String path, SdkException exception) {
        Object ioe;
        String message = String.format("%s%s: %s", new Object[]{operation, org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)path) ? " on " + path : "", exception});
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        if (!(exception instanceof AwsServiceException)) {
            Exception innerCause = S3AUtils.containsInterruptedException(exception);
            if (innerCause != null) {
                return S3AUtils.translateInterruptedException(exception, innerCause, message);
            }
            if (S3AUtils.isMessageTranslatableToEOF(exception)) {
                return (EOFException)new EOFException(message).initCause(exception);
            }
            IOException ioe2 = AuditIntegration.maybeTranslateAuditException(path, (Exception)((Object)exception));
            if (ioe2 != null) {
                return ioe2;
            }
            ioe2 = AWSCredentialProviderList.maybeTranslateCredentialException(path, exception);
            if (ioe2 != null) {
                return ioe2;
            }
            ioe2 = ErrorTranslation.maybeExtractIOException(path, exception, message);
            if (ioe2 != null) {
                return ioe2;
            }
            if (exception instanceof ApiCallTimeoutException || exception instanceof ApiCallAttemptTimeoutException) {
                return new AWSApiCallTimeoutException(message, (Exception)((Object)exception));
            }
            return new AWSClientIOException(message, exception);
        }
        AwsServiceException ase = (AwsServiceException)((Object)exception);
        S3Exception s3Exception = ase instanceof S3Exception ? (S3Exception)ase : null;
        int status = ase.statusCode();
        if (ase.awsErrorDetails() != null) {
            message = message + ":" + ase.awsErrorDetails().errorCode();
        }
        switch (status) {
            case 301: 
            case 307: {
                if (s3Exception != null) {
                    message = String.format("Received permanent redirect response to region %s.  This likely indicates that the S3 region configured in %s does not match the AWS region containing the bucket.", s3Exception.awsErrorDetails().sdkHttpResponse().headers().get("x-amz-bucket-region"), "fs.s3a.endpoint.region");
                    ioe = new AWSRedirectException(message, (AwsServiceException)s3Exception);
                    break;
                }
                ioe = new AWSRedirectException(message, ase);
                break;
            }
            case 400: {
                ioe = new AWSBadRequestException(message, ase);
                break;
            }
            case 401: 
            case 403: {
                ioe = new AccessDeniedException(path, null, message);
                ioe.initCause(ase);
                break;
            }
            case 404: {
                if (ErrorTranslation.isUnknownBucket(ase)) {
                    ioe = new UnknownStoreException(path, message, ase);
                    break;
                }
                ioe = new FileNotFoundException(message);
                ioe.initCause(ase);
                break;
            }
            case 409: {
                ioe = new AWSBadRequestException(message, ase);
                break;
            }
            case 410: {
                ioe = new FileNotFoundException(message);
                ioe.initCause(ase);
                break;
            }
            case 405: 
            case 415: 
            case 501: {
                ioe = new AWSUnsupportedFeatureException(message, (AwsServiceException)s3Exception);
                break;
            }
            case 412: {
                ioe = new RemoteFileChangedException(path, message, "", ase);
                break;
            }
            case 416: {
                ioe = new RangeNotSatisfiableEOFException(message, (Exception)((Object)ase));
                break;
            }
            case 443: 
            case 444: {
                ioe = new AWSNoResponseException(message, ase);
                break;
            }
            case 429: 
            case 503: {
                ioe = new AWSServiceThrottledException(message, ase);
                break;
            }
            case 504: {
                ioe = new AWSApiCallTimeoutException(message, (Exception)((Object)ase));
                break;
            }
            case 500: {
                ioe = new AWSStatus500Exception(message, ase);
                break;
            }
            case 200: {
                if (exception instanceof MultiObjectDeleteException) {
                    return ((MultiObjectDeleteException)((Object)exception)).translateException(message);
                }
            }
            default: {
                ioe = status > 500 ? new AWSStatus500Exception(message, ase) : (s3Exception != null ? new AWSS3IOException(message, s3Exception) : new AWSServiceIOException(message, ase));
            }
        }
        return ioe;
    }

    public static IOException extractException(String operation, String path, ExecutionException ee) {
        return S3AUtils.convertExceptionCause(operation, path, ee.getCause());
    }

    public static IOException extractException(String operation, String path, CompletionException ce) {
        return S3AUtils.convertExceptionCause(operation, path, ce.getCause());
    }

    private static IOException convertExceptionCause(String operation, String path, Throwable cause) {
        IOException ioe = cause instanceof SdkException ? S3AUtils.translateException(operation, path, (SdkException)cause) : (cause instanceof IOException ? (IOException)cause : new IOException(operation + " failed: " + cause, cause));
        return ioe;
    }

    static Exception containsInterruptedException(Throwable thrown) {
        if (thrown == null) {
            return null;
        }
        if (thrown instanceof InterruptedException || thrown instanceof InterruptedIOException || thrown instanceof AbortedException) {
            return (Exception)thrown;
        }
        return S3AUtils.containsInterruptedException(thrown.getCause());
    }

    private static InterruptedIOException translateInterruptedException(SdkException exception, Exception innerCause, String message) {
        String name;
        Object ioe = innerCause instanceof SocketTimeoutException ? new SocketTimeoutException(message) : ((name = innerCause.getClass().getName()).endsWith(".ConnectTimeoutException") || name.endsWith(".ConnectionPoolTimeoutException") || name.endsWith("$ConnectTimeoutException") ? new ConnectTimeoutException(message) : new InterruptedIOException(message));
        ((Throwable)ioe).initCause(exception);
        return ioe;
    }

    public static boolean isThrottleException(Exception ex) {
        return ex instanceof AWSServiceThrottledException || ex instanceof AwsServiceException && 503 == ((AwsServiceException)((Object)ex)).statusCode() || ex instanceof SdkException && RetryUtils.isThrottlingException((SdkException)((SdkException)((Object)ex)));
    }

    public static boolean isMessageTranslatableToEOF(SdkException ex) {
        return ex.toString().contains(EOF_MESSAGE_IN_XML_PARSER) || ex.toString().contains(EOF_READ_DIFFERENT_LENGTH);
    }

    public static String stringify(AwsServiceException e) {
        StringBuilder builder = new StringBuilder(String.format("%s error %d: %s; %s%s%n", e.awsErrorDetails().serviceName(), e.statusCode(), e.awsErrorDetails().errorCode(), e.awsErrorDetails().errorMessage(), e.retryable() ? " (retryable)" : ""));
        String rawResponseContent = e.awsErrorDetails().rawResponse().asUtf8String();
        if (rawResponseContent != null) {
            builder.append(rawResponseContent);
        }
        return builder.toString();
    }

    public static S3AFileStatus createFileStatus(Path keyPath, S3Object s3Object, long blockSize, String owner, String eTag, String versionId, boolean isCSEEnabled) {
        long size = s3Object.size();
        if (isCSEEnabled && size >= 16L) {
            size -= 16L;
        }
        return S3AUtils.createFileStatus(keyPath, S3AUtils.objectRepresentsDirectory(s3Object.key()), size, Date.from(s3Object.lastModified()), blockSize, owner, eTag, versionId);
    }

    public static S3AFileStatus createUploadFileStatus(Path keyPath, boolean isDir, long size, long blockSize, String owner, String eTag, String versionId) {
        Date date = isDir ? null : new Date();
        return S3AUtils.createFileStatus(keyPath, isDir, size, date, blockSize, owner, eTag, versionId);
    }

    private static S3AFileStatus createFileStatus(Path keyPath, boolean isDir, long size, Date modified, long blockSize, String owner, String eTag, String versionId) {
        if (isDir) {
            return new S3AFileStatus(Tristate.UNKNOWN, keyPath, owner);
        }
        return new S3AFileStatus(size, S3AUtils.dateToLong(modified), keyPath, blockSize, owner, eTag, versionId);
    }

    public static boolean objectRepresentsDirectory(String name) {
        return !name.isEmpty() && name.charAt(name.length() - 1) == '/';
    }

    public static long dateToLong(Date date) {
        if (date == null) {
            return 0L;
        }
        return date.getTime();
    }

    public static <InstanceT> InstanceT getInstanceFromReflection(String className, Configuration conf, @Nullable URI uri, Class<? extends InstanceT> interfaceImplemented, String methodName, String configKey) throws IOException {
        try {
            Method factory;
            Constructor<?> cons;
            Class<?> instanceClass = S3AUtils.class.getClassLoader().loadClass(className);
            if (Modifier.isAbstract(instanceClass.getModifiers())) {
                throw InstantiationIOException.isAbstract(uri, className, configKey);
            }
            if (!interfaceImplemented.isAssignableFrom(instanceClass)) {
                throw InstantiationIOException.isNotInstanceOf(uri, className, interfaceImplemented.getName(), configKey);
            }
            if (conf != null) {
                cons = S3AUtils.getConstructor(instanceClass, URI.class, Configuration.class);
                if (cons != null) {
                    return (InstanceT)cons.newInstance(uri, conf);
                }
                cons = S3AUtils.getConstructor(instanceClass, Configuration.class);
                if (cons != null) {
                    return (InstanceT)cons.newInstance(conf);
                }
            }
            if ((factory = S3AUtils.getFactoryMethod(instanceClass, interfaceImplemented, methodName)) != null) {
                return (InstanceT)factory.invoke(null, new Object[0]);
            }
            cons = S3AUtils.getConstructor(instanceClass, new Class[0]);
            if (cons != null) {
                return (InstanceT)cons.newInstance(new Object[0]);
            }
            throw InstantiationIOException.unsupportedConstructor(uri, className, configKey);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException == null) {
                targetException = e;
            }
            if (targetException instanceof IOException) {
                throw (IOException)targetException;
            }
            if (targetException instanceof SdkException) {
                throw S3AUtils.translateException("Instantiate " + className, "/", (SdkException)targetException);
            }
            throw InstantiationIOException.instantiationException(uri, className, configKey, targetException);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw InstantiationIOException.instantiationException(uri, className, configKey, e);
        }
    }

    public static boolean setIfDefined(Configuration config, String key, String val, String origin) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)val)) {
            config.set(key, val, origin);
            return true;
        }
        return false;
    }

    public static S3xLoginHelper.Login getAWSAccessKeys(URI name, Configuration conf) throws IOException {
        S3xLoginHelper.rejectSecretsInURIs(name);
        Configuration c = ProviderUtils.excludeIncompatibleCredentialProviders((Configuration)conf, S3AFileSystem.class);
        String bucket = name != null ? name.getHost() : "";
        String accessKey = S3AUtils.lookupPassword(bucket, c, "fs.s3a.access.key");
        String secretKey = S3AUtils.lookupPassword(bucket, c, "fs.s3a.secret.key");
        return new S3xLoginHelper.Login(accessKey, secretKey);
    }

    @Deprecated
    public static String lookupPassword(String bucket, Configuration conf, String baseKey, String overrideVal) throws IOException {
        return S3AUtils.lookupPassword(bucket, conf, baseKey, overrideVal, "");
    }

    public static String lookupPassword(String bucket, Configuration conf, String baseKey) throws IOException {
        return S3AUtils.lookupPassword(bucket, conf, baseKey, null, "");
    }

    @InterfaceAudience.LimitedPrivate(value={"Ranger"})
    public static String lookupPassword(String bucket, Configuration conf, String baseKey, String overrideVal, String defVal) throws IOException {
        String initialVal;
        Preconditions.checkArgument((boolean)baseKey.startsWith("fs.s3a."), (String)"%s does not start with $%s", (Object[])new Object[]{baseKey, "fs.s3a."});
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)bucket)) {
            String subkey = baseKey.substring("fs.s3a.".length());
            String shortBucketKey = String.format(BUCKET_PATTERN, bucket, subkey);
            String longBucketKey = String.format(BUCKET_PATTERN, bucket, baseKey);
            initialVal = S3AUtils.getPassword(conf, longBucketKey, overrideVal);
            initialVal = S3AUtils.getPassword(conf, shortBucketKey, initialVal);
        } else {
            initialVal = overrideVal;
        }
        return S3AUtils.getPassword(conf, baseKey, initialVal, defVal);
    }

    private static String getPassword(Configuration conf, String key, String val) throws IOException {
        return S3AUtils.getPassword(conf, key, val, "");
    }

    private static String getPassword(Configuration conf, String key, String val, String defVal) throws IOException {
        return org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)val) ? S3AUtils.lookupPassword(conf, key, defVal) : val;
    }

    static String lookupPassword(Configuration conf, String key, String defVal) throws IOException {
        try {
            char[] pass = conf.getPassword(key);
            return pass != null ? new String(pass).trim() : defVal;
        }
        catch (IOException ioe) {
            throw new IOException("Cannot find password option " + key, ioe);
        }
    }

    public static String stringify(S3Object s3Object) {
        StringBuilder builder = new StringBuilder(s3Object.key().length() + 100);
        builder.append("\"").append(s3Object.key()).append("\" ");
        builder.append("size=").append(s3Object.size());
        return builder.toString();
    }

    public static int intOption(Configuration conf, String key, int defVal, int min) {
        int v = conf.getInt(key, defVal);
        Preconditions.checkArgument((v >= min ? 1 : 0) != 0, (Object)String.format("Value of %s: %d is below the minimum value %d", key, v, min));
        LOG.debug("Value of {} is {}", (Object)key, (Object)v);
        return v;
    }

    public static long longOption(Configuration conf, String key, long defVal, long min) {
        long v = conf.getLong(key, defVal);
        Preconditions.checkArgument((v >= min ? 1 : 0) != 0, (Object)String.format("Value of %s: %d is below the minimum value %d", key, v, min));
        LOG.debug("Value of {} is {}", (Object)key, (Object)v);
        return v;
    }

    public static long longBytesOption(Configuration conf, String key, long defVal, long min) {
        long v = conf.getLongBytes(key, defVal);
        Preconditions.checkArgument((v >= min ? 1 : 0) != 0, (Object)String.format("Value of %s: %d is below the minimum value %d", key, v, min));
        LOG.debug("Value of {} is {}", (Object)key, (Object)v);
        return v;
    }

    public static long getMultipartSizeProperty(Configuration conf, String property, long defVal) {
        long partSize = conf.getLongBytes(property, defVal);
        if (partSize < 0x500000L) {
            LOG.warn("{} must be at least 5 MB; configured value is {}", (Object)property, (Object)partSize);
            partSize = 0x500000L;
        }
        return partSize;
    }

    public static void validateOutputStreamConfiguration(Path path, Configuration conf) throws PathIOException {
        if (!S3AUtils.checkDiskBuffer(conf)) {
            throw new PathIOException(path.toString(), "Unable to create OutputStream with the given multipart upload and buffer configuration.");
        }
    }

    public static boolean checkDiskBuffer(Configuration conf) {
        boolean isMultipartUploadEnabled = conf.getBoolean("fs.s3a.multipart.uploads.enabled", true);
        return isMultipartUploadEnabled || "disk".equals(conf.get("fs.s3a.fast.upload.buffer", "disk"));
    }

    public static int ensureOutputParameterInRange(String name, long size) {
        if (size > Integer.MAX_VALUE) {
            LOG.warn("s3a: {} capped to ~2.14GB (maximum allowed size with current output mechanism)", (Object)name);
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    private static Constructor<?> getConstructor(Class<?> cl, Class<?> ... args) {
        try {
            Constructor<?> cons = cl.getDeclaredConstructor(args);
            return Modifier.isPublic(cons.getModifiers()) ? cons : null;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    private static Method getFactoryMethod(Class<?> cl, Class<?> returnType, String methodName) {
        try {
            Method m = cl.getDeclaredMethod(methodName, new Class[0]);
            if (Modifier.isPublic(m.getModifiers()) && Modifier.isStatic(m.getModifiers()) && returnType.isAssignableFrom(m.getReturnType())) {
                return m;
            }
            return null;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"Ranger"})
    public static Configuration propagateBucketOptions(Configuration source, String bucket) {
        Preconditions.checkArgument((boolean)org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)bucket), (Object)"bucket is null/empty");
        String bucketPrefix = "fs.s3a.bucket." + bucket + '.';
        LOG.debug("Propagating entries under {}", (Object)bucketPrefix);
        Configuration dest = new Configuration(source);
        for (Map.Entry entry : source) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith(bucketPrefix) || bucketPrefix.equals(key)) continue;
            String stripped = key.substring(bucketPrefix.length());
            if (stripped.startsWith("bucket.") || "impl".equals(stripped)) {
                LOG.debug("Ignoring bucket option {}", (Object)key);
                continue;
            }
            String origin = "[" + org.apache.commons.lang3.StringUtils.join((Object[])source.getPropertySources(key), (String)", ") + "]";
            String generic = "fs.s3a." + stripped;
            LOG.debug("Updating {} from {}", (Object)generic, (Object)origin);
            dest.set(generic, value, key + " via " + origin);
        }
        return dest;
    }

    public static void deleteQuietly(FileSystem fs, Path path, boolean recursive) {
        try {
            fs.delete(path, recursive);
        }
        catch (IOException e) {
            LOG.debug("Failed to delete {}", (Object)path, (Object)e);
        }
    }

    public static void deleteWithWarning(FileSystem fs, Path path, boolean recursive) {
        try {
            fs.delete(path, recursive);
        }
        catch (IOException e) {
            LOG.warn("Failed to delete {}", (Object)path, (Object)e);
        }
    }

    public static S3AFileStatus[] iteratorToStatuses(RemoteIterator<S3AFileStatus> iterator) throws IOException {
        S3AFileStatus[] statuses = (S3AFileStatus[])RemoteIterators.toArray(iterator, (Object[])new S3AFileStatus[0]);
        return statuses;
    }

    public static long applyLocatedFiles(RemoteIterator<? extends LocatedFileStatus> iterator, CallOnLocatedFileStatus eval) throws IOException {
        return RemoteIterators.foreach(iterator, eval::call);
    }

    public static <T> List<T> mapLocatedFiles(RemoteIterator<? extends LocatedFileStatus> iterator, LocatedFileStatusMap<T> eval) throws IOException {
        ArrayList results = new ArrayList();
        S3AUtils.applyLocatedFiles(iterator, s -> results.add(eval.call(s)));
        return results;
    }

    public static <T> List<T> flatmapLocatedFiles(RemoteIterator<LocatedFileStatus> iterator, LocatedFileStatusMap<Optional<T>> eval) throws IOException {
        ArrayList results = new ArrayList();
        S3AUtils.applyLocatedFiles(iterator, s -> ((Optional)eval.call(s)).map(r -> results.add(r)));
        return results;
    }

    public static RemoteIterator<LocatedFileStatus> listAndFilter(FileSystem fileSystem, Path path, boolean recursive, PathFilter filter) throws IOException {
        return RemoteIterators.filteringRemoteIterator((RemoteIterator)fileSystem.listFiles(path, recursive), status -> filter.accept(status.getPath()));
    }

    public static <T> Optional<T> maybe(boolean include, T value) {
        return include ? Optional.of(value) : Optional.empty();
    }

    static void patchSecurityCredentialProviders(Configuration conf) {
        Collection customCredentials = conf.getStringCollection("fs.s3a.security.credential.provider.path");
        Collection hadoopCredentials = conf.getStringCollection(CREDENTIAL_PROVIDER_PATH);
        if (!customCredentials.isEmpty()) {
            ArrayList all = Lists.newArrayList((Iterable)customCredentials);
            all.addAll(hadoopCredentials);
            String joined = org.apache.commons.lang3.StringUtils.join((Iterable)all, (char)',');
            LOG.debug("Setting {} to {}", (Object)CREDENTIAL_PROVIDER_PATH, (Object)joined);
            conf.set(CREDENTIAL_PROVIDER_PATH, joined, "patch of fs.s3a.security.credential.provider.path");
        }
    }

    private static String lookupBucketSecret(String bucket, Configuration conf, String baseKey) throws IOException {
        Preconditions.checkArgument((!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)bucket) ? 1 : 0) != 0, (Object)"null/empty bucket argument");
        Preconditions.checkArgument((boolean)baseKey.startsWith("fs.s3a."), (String)"%s does not start with $%s", (Object[])new Object[]{baseKey, "fs.s3a."});
        String subkey = baseKey.substring("fs.s3a.".length());
        String longBucketKey = String.format(BUCKET_PATTERN, bucket, baseKey);
        String initialVal = S3AUtils.getPassword(conf, longBucketKey, null, null);
        String shortBucketKey = String.format(BUCKET_PATTERN, bucket, subkey);
        return S3AUtils.getPassword(conf, shortBucketKey, initialVal, null);
    }

    public static String getS3EncryptionKey(String bucket, Configuration conf) {
        try {
            return S3AUtils.getS3EncryptionKey(bucket, conf, false);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String getS3EncryptionKey(String bucket, Configuration conf, boolean propagateExceptions) throws IOException {
        try {
            String key = S3AUtils.lookupBucketSecret(bucket, conf, "fs.s3a.encryption.key");
            if (key == null) {
                key = S3AUtils.lookupBucketSecret(bucket, conf, "fs.s3a.server-side-encryption.key");
            }
            if (key == null) {
                key = S3AUtils.lookupPassword(null, conf, "fs.s3a.encryption.key");
            }
            if (key == null) {
                key = S3AUtils.lookupPassword(null, conf, "fs.s3a.server-side-encryption.key");
            }
            if (key == null) {
                key = "";
            }
            return key;
        }
        catch (IOException e) {
            if (propagateExceptions) {
                throw e;
            }
            LOG.warn("Cannot retrieve {} for bucket {}", new Object[]{"fs.s3a.encryption.key", bucket, e});
            return "";
        }
    }

    public static S3AEncryptionMethods getEncryptionAlgorithm(String bucket, Configuration conf) throws IOException {
        return S3AUtils.buildEncryptionSecrets(bucket, conf).getEncryptionMethod();
    }

    public static EncryptionSecrets buildEncryptionSecrets(String bucket, Configuration conf) throws IOException {
        S3AEncryptionMethods encryptionMethod;
        String encryptionKey;
        String algorithm = S3AUtils.lookupBucketSecret(bucket, conf, "fs.s3a.encryption.algorithm");
        if (algorithm == null) {
            algorithm = S3AUtils.lookupBucketSecret(bucket, conf, "fs.s3a.server-side-encryption-algorithm");
        }
        if (algorithm == null) {
            algorithm = S3AUtils.lookupPassword(null, conf, "fs.s3a.encryption.algorithm");
        }
        if (algorithm == null) {
            algorithm = S3AUtils.lookupPassword(null, conf, "fs.s3a.server-side-encryption-algorithm");
        }
        int encryptionKeyLen = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(encryptionKey = S3AUtils.getS3EncryptionKey(bucket, conf, (encryptionMethod = S3AEncryptionMethods.getMethod(algorithm)).requiresSecret()))) ? 0 : encryptionKey.length();
        String diagnostics = S3AUtils.passwordDiagnostics(encryptionKey, "key");
        switch (encryptionMethod) {
            case SSE_C: {
                LOG.debug("Using SSE-C with {}", (Object)diagnostics);
                if (encryptionKeyLen != 0) break;
                throw new IOException(SSE_C_NO_KEY_ERROR);
            }
            case SSE_S3: {
                if (encryptionKeyLen == 0) break;
                throw new IOException(SSE_S3_WITH_KEY_ERROR + " (" + diagnostics + ")");
            }
            case SSE_KMS: {
                LOG.debug("Using SSE-KMS with {}", (Object)diagnostics);
                break;
            }
            case CSE_KMS: {
                LOG.debug("Using CSE-KMS with {}", (Object)diagnostics);
                break;
            }
            case DSSE_KMS: {
                LOG.debug("Using DSSE-KMS with {}", (Object)diagnostics);
                break;
            }
            default: {
                LOG.debug("Data is unencrypted");
            }
        }
        return new EncryptionSecrets(encryptionMethod, encryptionKey);
    }

    private static String passwordDiagnostics(String pass, String description) {
        if (pass == null) {
            return "null " + description;
        }
        int len = pass.length();
        switch (len) {
            case 0: {
                return "empty " + description;
            }
            case 1: {
                return description + " of length 1";
            }
        }
        return description + " of length " + len + " ending with " + pass.charAt(len - 1);
    }

    @Deprecated
    public static void closeAll(Logger log, Closeable ... closeables) {
        IOUtils.cleanupWithLogger((Logger)log, (Closeable[])closeables);
    }

    public static void closeAutocloseables(Logger log, AutoCloseable ... closeables) {
        if (log == null) {
            log = LOG;
        }
        for (AutoCloseable c : closeables) {
            if (c == null) continue;
            try {
                log.debug("Closing {}", (Object)c);
                c.close();
            }
            catch (Exception e) {
                log.debug("Exception in closing {}", (Object)c, (Object)e);
            }
        }
    }

    public static void setBucketOption(Configuration conf, String bucket, String genericKey, String value) {
        String baseKey = genericKey.startsWith("fs.s3a.") ? genericKey.substring("fs.s3a.".length()) : genericKey;
        conf.set("fs.s3a.bucket." + bucket + '.' + baseKey, value, "S3AUtils");
    }

    public static void clearBucketOption(Configuration conf, String bucket, String genericKey) {
        String baseKey = genericKey.startsWith("fs.s3a.") ? genericKey.substring("fs.s3a.".length()) : genericKey;
        String k = "fs.s3a.bucket." + bucket + '.' + baseKey;
        LOG.debug("Unset {}", (Object)k);
        conf.unset(k);
    }

    public static String getBucketOption(Configuration conf, String bucket, String genericKey) {
        String baseKey = genericKey.startsWith("fs.s3a.") ? genericKey.substring("fs.s3a.".length()) : genericKey;
        return conf.get("fs.s3a.bucket." + bucket + '.' + baseKey);
    }

    public static String maybeAddTrailingSlash(String key) {
        if (!key.isEmpty() && !key.endsWith("/")) {
            return key + '/';
        }
        return key;
    }

    public static String formatRange(long rangeStart, long rangeEnd) {
        return String.format("bytes=%d-%d", rangeStart, rangeEnd);
    }

    public static Map<String, String> getTrimmedStringCollectionSplitByEquals(Configuration configuration, String name) {
        String valueString = configuration.get(name);
        if (null == valueString) {
            return new HashMap<String, String>();
        }
        return StringUtils.getTrimmedStringCollectionSplitByEquals((String)valueString);
    }

    static void maybeIsolateClassloader(Configuration conf, ClassLoader classLoader) {
        if (conf.getBoolean("fs.s3a.classloader.isolation", true)) {
            LOG.debug("Configuration classloader set to S3AFileSystem classloader: {}", (Object)classLoader);
            conf.setClassLoader(classLoader);
        } else {
            LOG.debug("Configuration classloader not changed, support classes needed will be loaded from the classloader that instantiated the Configuration object: {}", (Object)conf.getClassLoader());
        }
    }

    @FunctionalInterface
    public static interface LocatedFileStatusMap<T> {
        public T call(LocatedFileStatus var1) throws IOException;
    }

    @FunctionalInterface
    public static interface CallOnLocatedFileStatus {
        public void call(LocatedFileStatus var1) throws IOException;
    }
}

