/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.iceberg.metrics.MetricsReport;
import org.apache.iceberg.metrics.MetricsReporter;
import org.apache.iceberg.rest.ErrorHandlers;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.RESTRequest;
import org.apache.iceberg.rest.requests.ReportMetricsRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RESTMetricsReporter
implements MetricsReporter {
    private static final Logger LOG = LoggerFactory.getLogger(RESTMetricsReporter.class);
    private final RESTClient client;
    private final String metricsEndpoint;
    private final Supplier<Map<String, String>> headers;

    RESTMetricsReporter(RESTClient client, String metricsEndpoint, Supplier<Map<String, String>> headers) {
        this.client = client;
        this.metricsEndpoint = metricsEndpoint;
        this.headers = headers;
    }

    public void report(MetricsReport report) {
        if (null == report) {
            LOG.warn("Received invalid metrics report: null");
            return;
        }
        try {
            this.client.post(this.metricsEndpoint, (RESTRequest)ReportMetricsRequest.of(report), null, this.headers, ErrorHandlers.defaultErrorHandler());
        }
        catch (Exception e) {
            LOG.warn("Failed to report metrics to REST endpoint {}", (Object)this.metricsEndpoint, (Object)e);
        }
    }
}

