/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.StripedExecutor;

public class StripedExecutorTaskView {
    private final StripedExecutor.Stripe stripe;
    private final Runnable task;

    public StripedExecutorTaskView(StripedExecutor.Stripe stripe, Runnable task) {
        this.stripe = stripe;
        this.task = task;
    }

    @Order
    public int stripeIndex() {
        return this.stripe.index();
    }

    @Order(value=3)
    public String taskName() {
        return this.task.getClass().getName();
    }

    @Order(value=1)
    public String description() {
        return IgniteUtils.toStringSafe(this.task);
    }

    @Order(value=2)
    public String threadName() {
        return this.stripe.name();
    }
}

