/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.schema;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.apache.ignite3.internal.binarytuple.BinaryTupleParser;
import org.apache.ignite3.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite3.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.schema.BinaryTupleComparatorUtils;
import org.apache.ignite3.internal.schema.BinaryTuplePrefix;
import org.apache.ignite3.internal.schema.UnsafeByteBufferAccessor;
import org.apache.ignite3.internal.type.NativeType;
import org.apache.ignite3.sql.ColumnType;

public class PartialBinaryTupleMatcher {
    private final List<CatalogColumnCollation> columnCollations;
    private final List<NativeType> columnTypes;

    public PartialBinaryTupleMatcher(List<CatalogColumnCollation> columnCollations, List<NativeType> columnTypes) {
        this.columnCollations = columnCollations;
        this.columnTypes = columnTypes;
    }

    public int match(ByteBuffer buffer1, ByteBuffer buffer2) {
        assert (buffer1.order() == ByteOrder.LITTLE_ENDIAN);
        assert (buffer2.order() == ByteOrder.LITTLE_ENDIAN);
        boolean isBuffer1Prefix = BinaryTupleComparatorUtils.isFlagSet(buffer1, 8);
        boolean isBuffer2Prefix = BinaryTupleComparatorUtils.isFlagSet(buffer2, 8);
        int numElements = this.columnTypes.size();
        assert (!isBuffer1Prefix) : "An inline tuple must not contain a prefix.";
        BinaryTuple tuple1 = new BinaryTuple(numElements, buffer1, UnsafeByteBufferAccessor::new);
        BinaryTupleReader tuple2 = isBuffer2Prefix ? new BinaryTuplePrefix(numElements, buffer2) : new BinaryTuple(numElements, buffer2, UnsafeByteBufferAccessor::new);
        int columnsToCompare = Math.min(tuple1.elementCount(), tuple2.elementCount());
        assert (columnsToCompare <= numElements);
        for (int i = 0; i < columnsToCompare; ++i) {
            BinaryTupleParser.Readability readability = tuple1.valueReadability(i);
            if (readability == BinaryTupleParser.Readability.NOT_READABLE) {
                return 0;
            }
            int res = this.compareField(i, tuple1, tuple2, readability);
            if (res != 0) {
                return res;
            }
            if (readability != BinaryTupleParser.Readability.PARTIAL_READABLE) continue;
            return 0;
        }
        if (!isBuffer2Prefix) {
            return 0;
        }
        return -BinaryTupleComparatorUtils.equalityFlag(buffer2);
    }

    private int compareField(int colIdx, BinaryTupleReader tuple1, BinaryTupleReader tuple2, BinaryTupleParser.Readability readability) {
        assert (readability != BinaryTupleParser.Readability.NOT_READABLE) : "The field is run out of inline size and cannot be compared.";
        CatalogColumnCollation collation = this.columnCollations.get(colIdx);
        boolean tuple1HasNull = tuple1.hasNullValue(colIdx);
        boolean tuple2HasNull = tuple2.hasNullValue(colIdx);
        if (tuple1HasNull && tuple2HasNull) {
            return 0;
        }
        if (tuple1HasNull || tuple2HasNull) {
            return collation.nullsFirst() == tuple1HasNull ? -1 : 1;
        }
        NativeType nativeType = this.columnTypes.get(colIdx);
        int res = readability == BinaryTupleParser.Readability.READABLE ? BinaryTupleComparatorUtils.compareFieldValue(nativeType.spec(), tuple1, tuple2, colIdx) : PartialBinaryTupleMatcher.compareFieldValuePartially(nativeType.spec(), tuple1, tuple2, colIdx);
        return collation.asc() ? res : -res;
    }

    private static int compareFieldValuePartially(ColumnType typeSpec, BinaryTupleReader partialTuple, BinaryTupleReader tuple2, int index) {
        switch (typeSpec) {
            case BYTE_ARRAY: {
                return BinaryTupleComparatorUtils.compareAsBytes(partialTuple, tuple2, index);
            }
            case UUID: {
                return BinaryTupleComparatorUtils.compareAsUuid(partialTuple, tuple2, index);
            }
            case STRING: {
                return BinaryTupleComparatorUtils.compareAsString(partialTuple, tuple2, index, false);
            }
            case TIMESTAMP: {
                return BinaryTupleComparatorUtils.compareAsTimestamp(partialTuple, tuple2, index);
            }
        }
        return 0;
    }

    private static byte[] getTrimmedBytes(BinaryTupleReader tuple, int index, int maxLength) {
        tuple.seek(index);
        int begin = tuple.begin();
        int end = tuple.end();
        if (tuple.byteBuffer().get(begin) == -128) {
            ++maxLength;
        }
        int trimmedSize = Math.min(end - begin, maxLength);
        return tuple.bytesValue(begin, begin + trimmedSize);
    }
}

