/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.BytecodeUtils;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

class InvokeBytecodeExpression
extends BytecodeExpression {
    @Nullable
    private final BytecodeExpression instance;
    private final ParameterizedType methodTargetType;
    private final String methodName;
    private final ParameterizedType returnType;
    private final List<BytecodeExpression> parameters;
    private final List<ParameterizedType> parameterTypes;

    public static InvokeBytecodeExpression createInvoke(BytecodeExpression instance, String methodName, ParameterizedType returnType, Collection<ParameterizedType> parameterTypes, Collection<? extends BytecodeExpression> parameters) {
        return new InvokeBytecodeExpression(Objects.requireNonNull(instance, "instance is null"), instance.getType(), Objects.requireNonNull(methodName, "methodName is null"), Objects.requireNonNull(returnType, "returnType is null"), Objects.requireNonNull(parameterTypes, "parameterTypes is null"), Objects.requireNonNull(parameters, "parameters is null"));
    }

    InvokeBytecodeExpression(@Nullable BytecodeExpression instance, ParameterizedType methodTargetType, String methodName, ParameterizedType returnType, Collection<ParameterizedType> parameterTypes, Collection<? extends BytecodeExpression> parameters) {
        super(Objects.requireNonNull(returnType, "returnType is null"));
        BytecodeUtils.checkArgument(instance == null || !instance.getType().isPrimitive(), "Type %s does not have methods", this.getType());
        this.instance = instance;
        this.methodTargetType = Objects.requireNonNull(methodTargetType, "methodTargetType is null");
        this.methodName = Objects.requireNonNull(methodName, "methodName is null");
        this.returnType = returnType;
        this.parameterTypes = List.copyOf(Objects.requireNonNull(parameterTypes, "parameterTypes is null"));
        this.parameters = List.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        BytecodeBlock block = new BytecodeBlock();
        if (this.instance != null) {
            block.append(this.instance);
        }
        for (BytecodeExpression parameter : this.parameters) {
            block.append(parameter);
        }
        if (this.instance == null) {
            return block.invokeStatic(this.methodTargetType, this.methodName, this.returnType, this.parameterTypes);
        }
        if (this.instance.getType().isInterface()) {
            return block.invokeInterface(this.methodTargetType, this.methodName, this.returnType, this.parameterTypes);
        }
        return block.invokeVirtual(this.methodTargetType, this.methodName, this.returnType, this.parameterTypes);
    }

    @Override
    protected String formatOneLine() {
        if (this.instance == null) {
            return this.methodTargetType.getSimpleName() + "." + this.methodName + "(" + this.parameters.stream().map(BytecodeExpression::toString).collect(Collectors.joining(", ")) + ")";
        }
        return String.valueOf(this.instance) + "." + this.methodName + "(" + this.parameters.stream().map(BytecodeExpression::toString).collect(Collectors.joining(", ")) + ")";
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        if (this.instance == null) {
            return List.copyOf(this.parameters);
        }
        ArrayList<BytecodeExpression> children = new ArrayList<BytecodeExpression>(this.parameters.size() + 1);
        children.add(this.instance);
        children.addAll(this.parameters);
        return Collections.unmodifiableList(children);
    }
}

