/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import java.util.BitSet;
import java.util.stream.IntStream;
import org.apache.ignite.internal.table.distributed.PartitionSet;
import org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.apache.ignite.internal.tostring.S;

public class BitSetPartitionSet
implements PartitionSet {
    @IgniteToStringExclude
    private final BitSet backingSet;

    public BitSetPartitionSet() {
        this.backingSet = new BitSet();
    }

    private BitSetPartitionSet(BitSet backingSet) {
        this.backingSet = backingSet;
    }

    @Override
    public void set(int partitionId) {
        this.backingSet.set(partitionId);
    }

    @Override
    public void clear(int partitionId) {
        this.backingSet.clear(partitionId);
    }

    @Override
    public boolean get(int partitionId) {
        return this.backingSet.get(partitionId);
    }

    @Override
    public IntStream stream() {
        return this.backingSet.stream();
    }

    @Override
    public int size() {
        return this.backingSet.cardinality();
    }

    @Override
    public PartitionSet copy() {
        return new BitSetPartitionSet((BitSet)this.backingSet.clone());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof BitSetPartitionSet)) {
            return this.isEqual(o);
        }
        BitSetPartitionSet that = (BitSetPartitionSet)o;
        return this.backingSet.equals(that.backingSet);
    }

    public int hashCode() {
        return this.getHashCode();
    }

    public String toString() {
        return S.toString(BitSetPartitionSet.class, (Object)this, (String)"partitionIds=", (Object)this.backingSet.stream().toArray());
    }
}

