/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.metadata.RelColumnMapping;
import org.apache.calcite.rel.rules.ImmutableFilterTableFunctionTransposeRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Value;

@Value.Enclosing
public class FilterTableFunctionTransposeRule
extends RelRule<Config>
implements TransformationRule {
    protected FilterTableFunctionTransposeRule(Config config) {
        super(config);
    }

    @Deprecated
    public FilterTableFunctionTransposeRule(RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class).withOperandFor(LogicalFilter.class, LogicalTableFunctionScan.class));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        TableFunctionScan funcRel = (TableFunctionScan)call.rel(1);
        Set<RelColumnMapping> columnMappings = funcRel.getColumnMappings();
        if (columnMappings == null || columnMappings.isEmpty()) {
            return;
        }
        List<RelNode> funcInputs = funcRel.getInputs();
        if (funcInputs.size() != 1) {
            return;
        }
        if (funcRel.getRowType().getFieldCount() != funcInputs.get(0).getRowType().getFieldCount()) {
            return;
        }
        for (RelColumnMapping mapping : columnMappings) {
            if (mapping.iInputColumn != mapping.iOutputColumn) {
                return;
            }
            if (!mapping.derived) continue;
            return;
        }
        ArrayList<RelNode> newFuncInputs = new ArrayList<RelNode>();
        RexNode condition = filter.getCondition();
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        List<RelDataTypeField> origFields = funcRel.getRowType().getFieldList();
        int[] adjustments = new int[origFields.size()];
        for (RelNode funcInput : funcInputs) {
            RexNode newCondition = condition.accept(new RelOptUtil.RexInputConverter(rexBuilder, origFields, funcInput.getRowType().getFieldList(), adjustments));
            newFuncInputs.add(call.builder().push(funcInput).filter(newCondition).build());
        }
        RelNode newFuncRel = funcRel.copy(funcRel.getTraitSet(), newFuncInputs);
        call.transformTo(newFuncRel);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableFilterTableFunctionTransposeRule.Config.of().withOperandFor(Filter.class, TableFunctionScan.class);

        @Override
        default public FilterTableFunctionTransposeRule toRule() {
            return new FilterTableFunctionTransposeRule(this);
        }

        default public Config withOperandFor(Class<? extends Filter> filterClass, Class<? extends TableFunctionScan> tableFunctionScanClass) {
            return this.withOperandSupplier(b0 -> b0.operand(filterClass).oneInput(b1 -> b1.operand(tableFunctionScanClass).anyInputs())).as(Config.class);
        }
    }
}

