/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.nio.ContentDecoder;

public class ContentDecoderMock
implements ContentDecoder {
    private final ReadableByteChannel channel;
    private boolean completed;

    public ContentDecoderMock(ReadableByteChannel channel) {
        this.channel = channel;
    }

    public int read(ByteBuffer dst) throws IOException {
        if (this.completed) {
            return -1;
        }
        int bytesRead = this.channel.read(dst);
        if (bytesRead == -1) {
            this.completed = true;
        }
        return bytesRead;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public List<? extends Header> getTrailers() {
        return null;
    }
}

