/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.sftp;

import java.net.InetAddress;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.actions.sftp.SftpClient;
import org.w3c.dom.Node;

@Action(id="SFTP", name="i18n::ActionSFTP.Name", description="i18n::ActionSFTP.Description", image="SFTP.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileTransfer", keywords={"i18n::ActionSftp.keyword"}, documentationUrl="/workflow/actions/sftp.html")
public class ActionSftp
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionSftp.class;
    private static final String CONST_SPACE_SHORT = "      ";
    private static final String CONST_PASSWORD = "password";
    private static final int DEFAULT_PORT = 22;
    private String serverName = null;
    private String serverPort = "22";
    private String userName;
    private String password;
    private String sftpDirectory;
    private String targetDirectory;
    private String wildcard;
    private boolean remove;
    private boolean isaddresult = true;
    private boolean createtargetfolder = false;
    private boolean copyprevious = false;
    private boolean usekeyfilename = false;
    private String keyfilename = null;
    private String keyfilepass = null;
    private String compression = "none";
    private String proxyType = null;
    private String proxyHost = null;
    private String proxyPort = null;
    private String proxyUsername = null;
    private String proxyPassword = null;

    public ActionSftp(String n) {
        super(n, "");
    }

    public ActionSftp() {
        this("");
    }

    public Object clone() {
        ActionSftp je = (ActionSftp)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(200);
        retval.append(super.getXml());
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"serverport", (String)this.serverPort));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"username", (String)this.userName));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)CONST_PASSWORD, (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getPassword())));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"sftpdirectory", (String)this.sftpDirectory));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"targetdirectory", (String)this.targetDirectory));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"remove", (boolean)this.remove));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"isaddresult", (boolean)this.isaddresult));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"createtargetfolder", (boolean)this.createtargetfolder));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"copyprevious", (boolean)this.copyprevious));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"usekeyfilename", (boolean)this.usekeyfilename));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"keyfilename", (String)this.keyfilename));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"keyfilepass", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.keyfilepass)));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"compression", (String)this.compression));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"proxyType", (String)this.proxyType));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"proxyHost", (String)this.proxyHost));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"proxyPort", (String)this.proxyPort));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"proxyUsername", (String)this.proxyUsername));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"proxyPassword", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword)));
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.serverName = XmlHandler.getTagValue((Node)entrynode, (String)"servername");
            this.serverPort = XmlHandler.getTagValue((Node)entrynode, (String)"serverport");
            this.userName = XmlHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)entrynode, (String)CONST_PASSWORD));
            this.sftpDirectory = XmlHandler.getTagValue((Node)entrynode, (String)"sftpdirectory");
            this.targetDirectory = XmlHandler.getTagValue((Node)entrynode, (String)"targetdirectory");
            this.wildcard = XmlHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.remove = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"remove"));
            String addresult = XmlHandler.getTagValue((Node)entrynode, (String)"isaddresult");
            this.isaddresult = Utils.isEmpty((CharSequence)addresult) ? true : "Y".equalsIgnoreCase(addresult);
            this.createtargetfolder = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"createtargetfolder"));
            this.copyprevious = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"copyprevious"));
            this.usekeyfilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"usekeyfilename"));
            this.keyfilename = XmlHandler.getTagValue((Node)entrynode, (String)"keyfilename");
            this.keyfilepass = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)entrynode, (String)"keyfilepass"));
            this.compression = XmlHandler.getTagValue((Node)entrynode, (String)"compression");
            this.proxyType = XmlHandler.getTagValue((Node)entrynode, (String)"proxyType");
            this.proxyHost = XmlHandler.getTagValue((Node)entrynode, (String)"proxyHost");
            this.proxyPort = XmlHandler.getTagValue((Node)entrynode, (String)"proxyPort");
            this.proxyUsername = XmlHandler.getTagValue((Node)entrynode, (String)"proxyUsername");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)entrynode, (String)"proxyPassword"));
        }
        catch (HopXmlException xe) {
            throw new HopXmlException("Unable to load action of type 'SFTP' from XML node", (Throwable)xe);
        }
    }

    public String getScpDirectory() {
        return this.sftpDirectory;
    }

    public void setScpDirectory(String directory) {
        this.sftpDirectory = directory;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public void setAddToResult(boolean isaddresultin) {
        this.isaddresult = isaddresultin;
    }

    public boolean isAddToResult() {
        return this.isaddresult;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    public boolean isCreateTargetFolder() {
        return this.createtargetfolder;
    }

    public void setCreateTargetFolder(boolean createtargetfolder) {
        this.createtargetfolder = createtargetfolder;
    }

    public boolean isCopyPrevious() {
        return this.copyprevious;
    }

    public void setCopyPrevious(boolean copyprevious) {
        this.copyprevious = copyprevious;
    }

    public void setTargetDirectory(String targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public boolean getRemove() {
        return this.remove;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public boolean isUseKeyFile() {
        return this.usekeyfilename;
    }

    public void setUseKeyFile(boolean value) {
        this.usekeyfilename = value;
    }

    public String getKeyFilename() {
        return this.keyfilename;
    }

    public void setKeyFilename(String value) {
        this.keyfilename = value;
    }

    public String getKeyPassPhrase() {
        return this.keyfilepass;
    }

    public void setKeyPassPhrase(String value) {
        this.keyfilepass = value;
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(String value) {
        this.proxyType = value;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String value) {
        this.proxyHost = value;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String value) {
        this.proxyPort = value;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String value) {
        this.proxyUsername = value;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String value) {
        this.proxyPassword = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        List rows = result.getRows();
        RowMetaAndData resultRow = null;
        result.setResult(false);
        long filesRetrieved = 0L;
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSftp.Log.StartAction", (String[])new String[0]));
        }
        HashSet<String> listPreviousFilenames = new HashSet<String>();
        if (this.copyprevious) {
            if (rows.isEmpty()) {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSftp.ArgsFromPreviousNothing", (String[])new String[0]));
                }
                result.setResult(true);
                return result;
            }
            try {
                for (RowMetaAndData row : rows) {
                    resultRow = row;
                    String filePrevious = resultRow.getString(0, null);
                    if (Utils.isEmpty((CharSequence)filePrevious)) continue;
                    listPreviousFilenames.add(filePrevious);
                    if (!this.isDebug()) continue;
                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionSftp.Log.FilenameFromResult", (String[])new String[]{filePrevious}));
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionSftp.Error.ArgFromPrevious", (String[])new String[0]));
                result.setNrErrors(1L);
                return result;
            }
        }
        SftpClient sftpclient = null;
        String realServerName = this.resolve(this.serverName);
        String realServerPort = this.resolve(this.serverPort);
        String realUsername = this.resolve(this.userName);
        String realPassword = Encr.decryptPasswordOptionallyEncrypted((String)this.resolve(this.password));
        String realSftpDirString = this.resolve(this.sftpDirectory);
        String realWildcard = this.resolve(this.wildcard);
        String realTargetDirectory = this.resolve(this.targetDirectory);
        String realKeyFilename = null;
        String realPassPhrase = null;
        FileObject targetFolder = null;
        try {
            if (this.isUseKeyFile()) {
                realKeyFilename = this.resolve(this.getKeyFilename());
                if (Utils.isEmpty((CharSequence)realKeyFilename)) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionSftp.Error.KeyFileMissing", (String[])new String[0]));
                    result.setNrErrors(1L);
                    Result result2 = result;
                    return result2;
                }
                if (!HopVfs.fileExists((String)realKeyFilename)) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionSftp.Error.KeyFileNotFound", (String[])new String[]{realKeyFilename}));
                    result.setNrErrors(1L);
                    Result result3 = result;
                    return result3;
                }
                realPassPhrase = this.resolve(this.getKeyPassPhrase());
            }
            if (!Utils.isEmpty((CharSequence)realTargetDirectory)) {
                targetFolder = HopVfs.getFileObject((String)realTargetDirectory);
                boolean targetFolderExists = targetFolder.exists();
                if (targetFolderExists) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSftp.Log.TargetFolderExists", (String[])new String[]{realTargetDirectory}));
                    }
                } else {
                    if (!this.createtargetfolder) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionSftp.Error.TargetFolderNotExists", (String[])new String[]{realTargetDirectory}));
                        result.setNrErrors(1L);
                        Result result4 = result;
                        return result4;
                    }
                    targetFolder.createFolder();
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSftp.Log.TargetFolderCreated", (String[])new String[]{realTargetDirectory}));
                    }
                }
            }
            if (targetFolder != null) {
                targetFolder.close();
                targetFolder = null;
            }
            sftpclient = new SftpClient(InetAddress.getByName(realServerName), Const.toInt((String)realServerPort, (int)22), realUsername, realKeyFilename, realPassPhrase);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSftp.Log.OpenedConnection", (String[])new String[]{realServerName, realServerPort, realUsername}));
            }
            sftpclient.setCompression(this.getCompression());
            String realProxyHost = this.resolve(this.getProxyHost());
            if (!Utils.isEmpty((CharSequence)realProxyHost)) {
                String password = this.getRealPassword(this.getProxyPassword());
                sftpclient.setProxy(realProxyHost, this.resolve(this.getProxyPort()), this.resolve(this.getProxyUsername()), password, this.getProxyType());
            }
            sftpclient.login(realPassword);
            if (!Utils.isEmpty((CharSequence)realSftpDirString)) {
                try {
                    sftpclient.chdir(realSftpDirString);
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionSftp.Error.CanNotFindRemoteFolder", (String[])new String[]{realSftpDirString}));
                    throw new Exception(e);
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSftp.Log.ChangedDirectory", (String[])new String[]{realSftpDirString}));
                }
            }
            Pattern pattern = null;
            String[] filelist = sftpclient.dir();
            if (filelist == null) {
                result.setResult(true);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSftp.Log.Found", (String[])new String[]{"0"}));
                }
                Result result5 = result;
                return result5;
            }
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSftp.Log.Found", (String[])new String[]{"" + filelist.length}));
            }
            if (!this.copyprevious && !Utils.isEmpty((CharSequence)realWildcard)) {
                pattern = Pattern.compile(realWildcard);
            }
            for (int i = 0; i < filelist.length && !this.parentWorkflow.isStopped(); ++i) {
                boolean getIt = true;
                if (this.copyprevious) {
                    getIt = listPreviousFilenames.contains(filelist[i]);
                } else if (pattern != null) {
                    Matcher matcher = pattern.matcher(filelist[i]);
                    getIt = matcher.matches();
                }
                if (!getIt) continue;
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionSftp.Log.GettingFiles", (String[])new String[]{filelist[i], realTargetDirectory}));
                }
                FileObject targetFile = HopVfs.getFileObject((String)(realTargetDirectory + Const.FILE_SEPARATOR + filelist[i]));
                sftpclient.get(targetFile, filelist[i]);
                ++filesRetrieved;
                if (this.isaddresult) {
                    ResultFile resultFile = new ResultFile(0, targetFile, this.parentWorkflow.getWorkflowName(), this.toString());
                    result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSftp.Log.FilenameAddedToResultFilenames", (String[])new String[]{filelist[i]}));
                    }
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSftp.Log.TransferedFile", (String[])new String[]{filelist[i]}));
                }
                if (!this.remove) continue;
                sftpclient.delete(filelist[i]);
                if (!this.isDetailed()) continue;
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSftp.Log.DeletedFile", (String[])new String[]{filelist[i]}));
            }
            result.setResult(true);
            result.setNrFilesRetrieved(filesRetrieved);
            return result;
        }
        catch (Exception e) {
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(PKG, (String)"ActionSftp.Error.GettingFiles", (String[])new String[]{e.getMessage()}));
            this.logError(Const.getStackTracker((Throwable)e));
            return result;
        }
        finally {
            try {
                if (sftpclient != null) {
                    sftpclient.disconnect();
                }
            }
            catch (Exception exception) {}
            try {
                if (targetFolder != null) {
                    targetFolder.close();
                    targetFolder = null;
                }
                if (listPreviousFilenames != null) {
                    listPreviousFilenames = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    public String getRealPassword(String password) {
        return Utils.resolvePassword((IVariables)this, (String)password);
    }

    public boolean isEvaluation() {
        return true;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.serverName)) {
            String realServerName = this.resolve(this.serverName);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realServerName, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "serverName", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.fileExistsValidator()});
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "targetDirectory", remarks, ctx);
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "userName", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, CONST_PASSWORD, remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "serverPort", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.integerValidator()}));
    }
}

