/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import java.util.Collection;
import org.apache.beam.runners.spark.structuredstreaming.translation.utils.ScalaInterop;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import scala.Tuple2;
import scala.collection.TraversableOnce;

class GroupByKeyHelpers {
    private GroupByKeyHelpers() {
    }

    static @UnknownKeyFor @NonNull @Initialized boolean eligibleForGroupByWindow(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowing, @UnknownKeyFor @NonNull @Initialized boolean endOfWindowOnly) {
        return !windowing.needsMerge() && (!endOfWindowOnly || windowing.getTimestampCombiner() == TimestampCombiner.END_OF_WINDOW) && windowing.getWindowFn().windowCoder().consistentWithEquals();
    }

    static @UnknownKeyFor @NonNull @Initialized boolean eligibleForGlobalGroupBy(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowing, @UnknownKeyFor @NonNull @Initialized boolean endOfWindowOnly) {
        return windowing.getWindowFn() instanceof GlobalWindows && (!endOfWindowOnly || windowing.getTimestampCombiner() == TimestampCombiner.END_OF_WINDOW);
    }

    static <K, V, T> @UnknownKeyFor @NonNull @Initialized ScalaInterop.Fun1<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, @UnknownKeyFor @NonNull @Initialized TraversableOnce<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized BoundedWindow, K>, T>>> explodeWindowedKey(@UnknownKeyFor @NonNull @Initialized ScalaInterop.Fun1<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, T> valueFn) {
        return v -> {
            Object value = valueFn.apply(v);
            Object key = ((KV)v.getValue()).getKey();
            Collection windows = v.getWindows();
            return ScalaInterop.scalaIterator(windows).map(w -> ScalaInterop.tuple(ScalaInterop.tuple(w, key), value));
        };
    }

    static <K, V> @UnknownKeyFor @NonNull @Initialized ScalaInterop.Fun1<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized BoundedWindow, K>, V>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> windowedKV() {
        return t -> GroupByKeyHelpers.windowedKV((Tuple2)t._1, t._2);
    }

    static <K, V> @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>> windowedKV(@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized BoundedWindow, K> key, V value) {
        return WindowedValues.of((Object)KV.of((Object)key._2, value), (Instant)((BoundedWindow)key._1).maxTimestamp(), (BoundedWindow)((BoundedWindow)key._1), (PaneInfo)PaneInfo.NO_FIRING);
    }

    static <V> @UnknownKeyFor @NonNull @Initialized ScalaInterop.Fun1<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>, V> value() {
        return v -> v.getValue();
    }

    static <K, V> @UnknownKeyFor @NonNull @Initialized ScalaInterop.Fun1<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, V> valueValue() {
        return v -> ((KV)v.getValue()).getValue();
    }

    static <K, V> @UnknownKeyFor @NonNull @Initialized ScalaInterop.Fun1<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, K> valueKey() {
        return v -> ((KV)v.getValue()).getKey();
    }
}

