/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.minio.util;

import io.minio.PutObjectArgs;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.vfs.minio.MinioFileSystem;

public class MinioPipedOutputStream
extends PipedOutputStream {
    private static final Class<?> PKG = MinioPipedOutputStream.class;
    private boolean initialized = false;
    private boolean blockedUntilDone = true;
    private final PipedInputStream pipedInputStream;
    private final MinioAsyncTransferRunner asyncTransferRunner;
    private final MinioFileSystem fileSystem;
    private AtomicBoolean result = new AtomicBoolean(false);
    private final String bucketName;
    private final String key;

    public MinioPipedOutputStream(MinioFileSystem fileSystem, String bucketName, String key) throws IOException {
        this.pipedInputStream = new PipedInputStream(100000);
        try {
            this.pipedInputStream.connect(this);
        }
        catch (IOException e) {
            throw new IOException("A MinIO piped output stream could not connect to the input stream", e);
        }
        this.asyncTransferRunner = new MinioAsyncTransferRunner();
        this.bucketName = bucketName;
        this.key = key;
        this.fileSystem = fileSystem;
    }

    private void initializeWrite() {
        if (!this.initialized) {
            this.initialized = true;
            new Thread(this.asyncTransferRunner).start();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.initializeWrite();
        super.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.initializeWrite();
        super.write(b, off, len);
    }

    @Override
    public synchronized void flush() {
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.initialized && this.isBlockedUntilDone()) {
            while (!this.result.get()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LogChannel.GENERAL.logError(BaseMessages.getString(PKG, (String)"ERROR.S3MultiPart.ExceptionCaught", (String[])new String[0]), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    @Generated
    public boolean isInitialized() {
        return this.initialized;
    }

    @Generated
    public boolean isBlockedUntilDone() {
        return this.blockedUntilDone;
    }

    @Generated
    public PipedInputStream getPipedInputStream() {
        return this.pipedInputStream;
    }

    @Generated
    public MinioAsyncTransferRunner getAsyncTransferRunner() {
        return this.asyncTransferRunner;
    }

    @Generated
    public MinioFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Generated
    public AtomicBoolean getResult() {
        return this.result;
    }

    @Generated
    public String getBucketName() {
        return this.bucketName;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Generated
    public void setBlockedUntilDone(boolean blockedUntilDone) {
        this.blockedUntilDone = blockedUntilDone;
    }

    @Generated
    public void setResult(AtomicBoolean result) {
        this.result = result;
    }

    class MinioAsyncTransferRunner
    implements Runnable {
        MinioAsyncTransferRunner() {
        }

        @Override
        public void run() {
            try {
                PutObjectArgs args = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().contentType("application/octet-stream").bucket(MinioPipedOutputStream.this.bucketName)).object(MinioPipedOutputStream.this.key)).stream((InputStream)MinioPipedOutputStream.this.pipedInputStream, -1L, MinioPipedOutputStream.this.fileSystem.getPartSize()).build();
                MinioPipedOutputStream.this.fileSystem.getClient().putObject(args);
            }
            catch (Exception e) {
                throw new RuntimeException("Error writing to MinIO bucket " + MinioPipedOutputStream.this.bucketName + ", object " + MinioPipedOutputStream.this.key, e);
            }
            finally {
                MinioPipedOutputStream.this.result.set(true);
            }
        }
    }
}

