/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.SharedLinkFileInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class PathOrLink {
    public static final PathOrLink OTHER = new PathOrLink().withTag(Tag.OTHER);
    private Tag _tag;
    private String pathValue;
    private SharedLinkFileInfo linkValue;

    private PathOrLink() {
    }

    private PathOrLink withTag(Tag _tag) {
        PathOrLink result = new PathOrLink();
        result._tag = _tag;
        return result;
    }

    private PathOrLink withTagAndPath(Tag _tag, String pathValue) {
        PathOrLink result = new PathOrLink();
        result._tag = _tag;
        result.pathValue = pathValue;
        return result;
    }

    private PathOrLink withTagAndLink(Tag _tag, SharedLinkFileInfo linkValue) {
        PathOrLink result = new PathOrLink();
        result._tag = _tag;
        result.linkValue = linkValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isPath() {
        return this._tag == Tag.PATH;
    }

    public static PathOrLink path(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (!Pattern.matches("(/(.|[\\r\\n])*|id:.*)|(rev:[0-9a-f]{9,})|(ns:[0-9]+(/.*)?)", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new PathOrLink().withTagAndPath(Tag.PATH, value);
    }

    public String getPathValue() {
        if (this._tag != Tag.PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH, but was Tag." + this._tag.name());
        }
        return this.pathValue;
    }

    public boolean isLink() {
        return this._tag == Tag.LINK;
    }

    public static PathOrLink link(SharedLinkFileInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new PathOrLink().withTagAndLink(Tag.LINK, value);
    }

    public SharedLinkFileInfo getLinkValue() {
        if (this._tag != Tag.LINK) {
            throw new IllegalStateException("Invalid tag: required Tag.LINK, but was Tag." + this._tag.name());
        }
        return this.linkValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.pathValue, this.linkValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof PathOrLink) {
            PathOrLink other = (PathOrLink)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case PATH: {
                    return this.pathValue == other.pathValue || this.pathValue.equals(other.pathValue);
                }
                case LINK: {
                    return this.linkValue == other.linkValue || this.linkValue.equals(other.linkValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<PathOrLink> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PathOrLink value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case PATH: {
                    g.writeStartObject();
                    this.writeTag("path", g);
                    g.writeFieldName("path");
                    StoneSerializers.string().serialize(value.pathValue, g);
                    g.writeEndObject();
                    break;
                }
                case LINK: {
                    g.writeStartObject();
                    this.writeTag("link", g);
                    SharedLinkFileInfo.Serializer.INSTANCE.serialize(value.linkValue, g, true);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public PathOrLink deserialize(JsonParser p) throws IOException, JsonParseException {
            PathOrLink value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("path".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("path", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = PathOrLink.path(fieldValue);
            } else if ("link".equals(tag)) {
                SharedLinkFileInfo fieldValue = null;
                fieldValue = SharedLinkFileInfo.Serializer.INSTANCE.deserialize(p, true);
                value = PathOrLink.link(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        PATH,
        LINK,
        OTHER;

    }
}

