/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.debug.action;

import java.awt.image.BufferedImage;
import java.util.Map;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.gui.AreaOwner;
import org.apache.hop.core.gui.Rectangle;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.debug.action.ActionDebugLevel;
import org.apache.hop.debug.util.BeePainter;
import org.apache.hop.debug.util.DebugLevelUtil;
import org.apache.hop.workflow.WorkflowPainterExtension;

@ExtensionPoint(id="DrawActionDebugLevelBeeExtensionPoint", description="Draw a bee over a workflow entry which has debug level information stored", extensionPointId="WorkflowPainterAction")
public class DrawActionDebugLevelBeeExtensionPoint
extends BeePainter
implements IExtensionPoint<WorkflowPainterExtension> {
    private static BufferedImage beeImage;

    public void callExtensionPoint(ILogChannel log, IVariables variables, WorkflowPainterExtension ext) {
        try {
            ActionDebugLevel actionDebugLevel;
            Map actionLevelMap = (Map)ext.workflowMeta.getAttributesMap().get("debug_plugin");
            if (actionLevelMap != null && (actionDebugLevel = DebugLevelUtil.getActionDebugLevel(actionLevelMap, ext.actionMeta.toString())) != null) {
                Rectangle r = this.drawBee(ext.gc, ext.x1, ext.y1, ext.iconSize, this.getClass().getClassLoader());
                ext.areaOwners.add(new AreaOwner(AreaOwner.AreaType.CUSTOM, r.x, r.y, r.width, r.height, ext.offset, (Object)ext.actionMeta, (Object)actionDebugLevel));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

