/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.registries;

import java.util.Map;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.SchemaObjectType;
import org.apache.directory.api.ldap.model.schema.registries.ComparatorRegistry;
import org.apache.directory.api.ldap.model.schema.registries.DefaultSchemaObjectRegistry;
import org.apache.directory.api.ldap.model.schema.registries.OidRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultComparatorRegistry
extends DefaultSchemaObjectRegistry<LdapComparator<?>>
implements ComparatorRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultComparatorRegistry.class);

    public DefaultComparatorRegistry() {
        super(SchemaObjectType.COMPARATOR, new OidRegistry());
    }

    @Override
    public void unregisterSchemaElements(String schemaName) throws LdapException {
        if (schemaName == null) {
            return;
        }
        for (LdapComparator comparator : this) {
            if (!schemaName.equalsIgnoreCase(comparator.getSchemaName())) continue;
            String oid = comparator.getOid();
            String removed = this.unregister(oid);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(I18n.msg((I18n)I18n.MSG_13702_REMOVED_FROM_REGISTRY, (Object[])new Object[]{removed, oid}));
        }
    }

    @Override
    public DefaultComparatorRegistry copy() {
        DefaultComparatorRegistry copy = new DefaultComparatorRegistry();
        copy.copy(this);
        return copy;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.schemaObjectType).append(": ");
        boolean isFirst = true;
        for (Map.Entry entry : this.byName.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            LdapComparator comparator = (LdapComparator)entry.getValue();
            String fqcn = comparator.getFqcn();
            int lastDotPos = fqcn.lastIndexOf(46);
            sb.append('<').append(comparator.getOid()).append(", ");
            if (lastDotPos > 0) {
                sb.append(fqcn.substring(lastDotPos + 1));
            } else {
                sb.append(fqcn);
            }
            sb.append('>');
        }
        return sb.toString();
    }
}

