/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.metadata.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import org.apache.hop.core.exception.HopException;

public class ReflectionUtil {
    public static final String getSetterMethodName(String name) {
        StringBuilder setter = new StringBuilder();
        setter.append("set");
        setter.append(name.substring(0, 1).toUpperCase());
        setter.append(name.substring(1));
        return setter.toString();
    }

    public static final String getGetterMethodName(String name, boolean isBoolean) {
        StringBuilder setter = new StringBuilder();
        setter.append(isBoolean ? "is" : "get");
        setter.append(name.substring(0, 1).toUpperCase());
        setter.append(name.substring(1));
        return setter.toString();
    }

    public static final List<Field> findAllFields(Class<?> clazz) {
        HashSet<Field> fieldsSet = new HashSet<Field>();
        for (Field classField : clazz.getDeclaredFields()) {
            fieldsSet.add(classField);
        }
        for (Class<?> superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            for (Field superClassField : superClass.getDeclaredFields()) {
                fieldsSet.add(superClassField);
            }
        }
        ArrayList<Field> fields = new ArrayList<Field>(fieldsSet);
        Collections.sort(fields, Comparator.comparing(Field::getName));
        return fields;
    }

    public static final List<Field> findAllFields(Class<?> clazz, Function<Field, String> sortFunction) {
        HashSet<Field> fieldsSet = new HashSet<Field>();
        for (Field classField : clazz.getDeclaredFields()) {
            String keyField = sortFunction.apply(classField);
            if (keyField == null) continue;
            fieldsSet.add(classField);
        }
        for (Class<?> superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            for (Field superClassField : superClass.getDeclaredFields()) {
                String keyField = sortFunction.apply(superClassField);
                if (keyField == null) continue;
                fieldsSet.add(superClassField);
            }
        }
        ArrayList<Field> fields = new ArrayList<Field>(fieldsSet);
        Collections.sort(fields, Comparator.comparing(sortFunction::apply));
        return fields;
    }

    public static final Object getFieldValue(Object object, String fieldName, boolean isBoolean) throws HopException {
        Class<?> objectClass = object.getClass();
        String getterMethodName = ReflectionUtil.getGetterMethodName(fieldName, isBoolean);
        try {
            Method getterMethod = objectClass.getMethod(getterMethodName, new Class[0]);
            return getterMethod.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new HopException("Error getting value for field '" + fieldName + "' using method '" + getterMethodName + "' in class '" + objectClass.getName(), e);
        }
    }

    public static final void setFieldValue(Object object, String fieldName, Class<?> fieldType, Object fieldValue) throws HopException {
        Class<?> objectClass = object.getClass();
        String setterMethodName = ReflectionUtil.getSetterMethodName(fieldName);
        try {
            Method setterMethod = objectClass.getMethod(setterMethodName, fieldType);
            setterMethod.invoke(object, fieldValue);
        }
        catch (Exception e) {
            throw new HopException("Error setting value on field '" + fieldName + "' using method '" + setterMethodName + "' in class '" + objectClass.getName(), e);
        }
    }

    public static String getObjectName(Object object) throws HopException {
        try {
            return (String)ReflectionUtil.getFieldValue(object, "name", false);
        }
        catch (Exception e) {
            throw new HopException("Unable to get the name of Hop metadata class '" + object.getClass().getName() + "'", e);
        }
    }
}

