/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.clickhouse;

import org.apache.commons.lang.Validate;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;

@DatabaseMetaPlugin(type="CLICKHOUSE", typeDescription="ClickHouse", image="clikhouse.svg", documentationUrl="/database/databases/clickhouse.html")
@GuiPlugin(id="GUI-ClickhouseDatabaseMeta")
public class ClickhouseDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public static final String CONST_ALTER_TABLE = "ALTER TABLE ";

    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 8123;
        }
        return -1;
    }

    public String getDriverClass() {
        return "com.clickhouse.jdbc.ClickHouseDriver";
    }

    public boolean isSupportsCustomDeleteStmt() {
        return true;
    }

    public boolean isSupportsCustomUpdateStmt() {
        return true;
    }

    public String getSqlDeleteStmt(String tableName) {
        return CONST_ALTER_TABLE + tableName + " DELETE ";
    }

    public String getSqlUpdateStmt(String tableName) {
        return CONST_ALTER_TABLE + tableName + " UPDATE ";
    }

    public String getURL(String hostName, String port, String databaseName) {
        Validate.notEmpty((String)hostName, (String)"Host name is empty");
        String url = "jdbc:clickhouse://" + hostName.toLowerCase();
        if (!Utils.isEmpty((CharSequence)port)) {
            url = url + ":" + port;
        }
        if (!Utils.isEmpty((CharSequence)databaseName)) {
            url = url + "/" + databaseName;
        }
        return url;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return CONST_ALTER_TABLE + tableName + " ADD COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getDropColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return CONST_ALTER_TABLE + tableName + " DROP COLUMN " + v.getName() + Const.CR;
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return CONST_ALTER_TABLE + tableName + " MODIFY COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getFieldDefinition(IValueMeta v, String surrogateKey, String primaryKey, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        boolean isKeyField;
        Object retval = "";
        String newline = addCr ? Const.CR : "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        int type = v.getType();
        boolean bl = isKeyField = fieldname.equalsIgnoreCase(surrogateKey) || fieldname.equalsIgnoreCase(primaryKey);
        if (addFieldName) {
            retval = (String)retval + fieldname + " ";
        }
        if (isKeyField) {
            Validate.isTrue((type == 1 || type == 5 || type == 6 ? 1 : 0) != 0);
            return this.ddlForPrimaryKey() + newline;
        }
        switch (type) {
            case 9: {
                retval = (String)retval + "DATETIME";
                break;
            }
            case 3: {
                retval = (String)retval + "DATE";
                break;
            }
            case 4: {
                retval = (String)retval + "UINT8";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (type == 5) {
                    if (length > 18) {
                        retval = (String)retval + "INT128";
                        break;
                    }
                    if (length > 9) {
                        retval = (String)retval + "INT64";
                        break;
                    }
                    retval = (String)retval + "INT32";
                    break;
                }
                if (type == 6) {
                    if (length < 1) {
                        length = 16;
                    }
                    if (precision < 1) {
                        precision = 16;
                    }
                    retval = (String)retval + "DECIMAL(" + length + "," + precision + ")";
                    break;
                }
                retval = (String)retval + "FLOAT64";
                break;
            }
            case 2: {
                retval = (String)retval + "STRING";
                break;
            }
            case 8: {
                retval = (String)retval + "UNSUPPORTED";
                break;
            }
            default: {
                retval = (String)retval + "UNKNOWN";
            }
        }
        return (String)retval + newline;
    }

    private String ddlForPrimaryKey() {
        return "UUID NOT NULL PRIMARY KEY";
    }

    public String getLimitClause(int nrRows) {
        return " LIMIT " + nrRows;
    }

    public String getSqlQueryFields(String tableName) {
        return "SELECT * FROM " + tableName + " LIMIT 0";
    }

    public String getSqlTableExists(String tableName) {
        return this.getSqlQueryFields(tableName);
    }

    public String getSqlColumnExists(String columnname, String tableName) {
        return this.getSqlQueryColumnFields(columnname, tableName);
    }

    public String getSqlQueryColumnFields(String columnname, String tableName) {
        return "SELECT " + columnname + " FROM " + tableName + " LIMIT 0";
    }

    public String getExtraOptionSeparator() {
        return "&";
    }

    public boolean isQuoteAllFields() {
        return false;
    }

    public String getExtraOptionIndicator() {
        return "?";
    }

    public boolean isSupportsSchemas() {
        return false;
    }

    public boolean isSupportsTransactions() {
        return false;
    }

    public boolean isSupportsViews() {
        return true;
    }

    public boolean isSupportsSequences() {
        return false;
    }

    public boolean isSupportsSynonyms() {
        return true;
    }

    public boolean IsSupportsErrorHandlingOnBatchUpdates() {
        return true;
    }

    public String[] getReservedWords() {
        return new String[]{"ALL", "ALTER", "AND", "ANY", "AS", "ASC", "BETWEEN", "BY", "CASE", "CAST", "CHECK", "CLUSTER", "COLUMN", "CONNECT", "CREATE", "CROSS", "CURRENT", "DELETE", "DESC", "DISTINCT", "DROP", "ELSE", "EXCLUSIVE", "EXISTS", "FALSE", "FOR", "FROM", "FULL", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INNER", "INSERT", "INTERSECT", "INTO", "IS", "JOIN", "LATERAL", "LEFT", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MODIFY", "NATURAL", "NOT", "NULL", "OF", "ON", "OPTION", "OR", "ORDER", "REGEXP", "RENAME", "REVOKE", "RIGHT", "RLIKE", "ROW", "ROWS", "SELECT", "SET", "SOME", "START", "TABLE", "THEN", "TO", "TRIGGER", "TRUE", "UNION", "UNIQUE", "UPDATE", "USING", "VALUES", "WHEN", "WHENEVER", "WHERE", "WITH"};
    }

    public String getExtraOptionsHelpText() {
        return "https://github.com/ClickHouse/clickhouse-jdbc";
    }

    public String getSqlInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        return "insert into " + schemaTable + "(" + keyField + ", " + versionField + ") values (1, 1)";
    }

    public String quoteSqlString(String string) {
        string = string.replace("'", "\\\\'");
        string = string.replace("\\n", "\\\\n");
        string = string.replace("\\r", "\\\\r");
        return "'" + string + "'";
    }

    public boolean isReleaseSavepoint() {
        return false;
    }

    public boolean isRequiringTransactionsOnQueries() {
        return false;
    }

    public boolean isRequiresName() {
        return false;
    }

    public boolean useSchemaNameForTableList() {
        return false;
    }

    public boolean isSupportsTimeStampToDateConversion() {
        return false;
    }

    public void addDefaultOptions() {
        this.setSupportsTimestampDataType(true);
    }
}

