/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.dropbox;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileNameParser;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;
import org.apache.hop.vfs.dropbox.DropboxFileName;

public class DropboxFileNameParser
extends AbstractFileNameParser {
    private static final DropboxFileNameParser INSTANCE = new DropboxFileNameParser();

    private DropboxFileNameParser() {
    }

    public static FileNameParser getInstance() {
        return INSTANCE;
    }

    public FileName parseUri(VfsComponentContext context, FileName base, String uri) throws FileSystemException {
        StringBuilder name = new StringBuilder();
        String scheme = UriParser.extractScheme((String[])context.getFileSystemManager().getSchemes(), (String)uri, (StringBuilder)name);
        UriParser.canonicalizePath((StringBuilder)name, (int)0, (int)name.length(), (FileNameParser)this);
        UriParser.fixSeparators((StringBuilder)name);
        FileType fileType = UriParser.normalisePath((StringBuilder)name);
        return new DropboxFileName(scheme, name.toString(), fileType);
    }
}

