/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.functions.util;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.api.common.functions.RuntimeContext;

@Internal
public final class FunctionUtils {
    public static void openFunction(Function function, OpenContext openContext) throws Exception {
        if (function instanceof RichFunction) {
            RichFunction richFunction = (RichFunction)function;
            richFunction.open(openContext);
        }
    }

    public static void closeFunction(Function function) throws Exception {
        if (function instanceof RichFunction) {
            RichFunction richFunction = (RichFunction)function;
            richFunction.close();
        }
    }

    public static void setFunctionRuntimeContext(Function function, RuntimeContext context) {
        if (function instanceof RichFunction) {
            RichFunction richFunction = (RichFunction)function;
            richFunction.setRuntimeContext(context);
        }
    }

    public static RuntimeContext getFunctionRuntimeContext(Function function, RuntimeContext defaultContext) {
        if (function instanceof RichFunction) {
            RichFunction richFunction = (RichFunction)function;
            return richFunction.getRuntimeContext();
        }
        return defaultContext;
    }

    private FunctionUtils() {
        throw new RuntimeException();
    }
}

