/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.server.HttpUtil;
import org.apache.hop.workflow.action.ActionStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HopServerWorkflowStatus {
    public static final String XML_TAG = "workflow-status";
    private static final String CONST_ACTION_STATUS = "action_status_list";
    private static final String CONST_LOG_DATE = "log_date";
    private String workflowName;
    private String id;
    private String statusDescription;
    private String errorDescription;
    private String loggingString;
    private int firstLoggingLineNr;
    private int lastLoggingLineNr;
    private List<ActionStatus> actionStatusList;
    private Result result;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    private Date logDate = new Date();
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    private Date executionStartDate;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    private Date executionEndDate;

    public HopServerWorkflowStatus() {
        this.actionStatusList = new ArrayList<ActionStatus>();
    }

    public HopServerWorkflowStatus(String workflowName, String id, String statusDescription) {
        this();
        this.workflowName = workflowName;
        this.id = id;
        this.statusDescription = statusDescription;
    }

    @JsonIgnore
    public String getXml() throws HopException {
        boolean sendResultXmlWithStatus = EnvUtil.getSystemProperty((String)"HOP_COMPATIBILITY_SEND_RESULT_XML_WITH_FULL_STATUS", (String)"N").equalsIgnoreCase("Y");
        StringBuilder xml = new StringBuilder();
        xml.append(XmlHandler.openTag((String)XML_TAG)).append(Const.CR);
        xml.append("  ").append(XmlHandler.addTagValue((String)"workflowname", (String)this.workflowName));
        xml.append("  ").append(XmlHandler.addTagValue((String)"id", (String)this.id));
        xml.append("  ").append(XmlHandler.addTagValue((String)"status_desc", (String)this.statusDescription));
        xml.append("  ").append(XmlHandler.addTagValue((String)"error_desc", (String)this.errorDescription));
        xml.append("  ").append(XmlHandler.addTagValue((String)CONST_LOG_DATE, (String)XmlHandler.date2string((Date)this.logDate)));
        xml.append("  ").append(XmlHandler.addTagValue((String)"execution_start_date", (String)XmlHandler.date2string((Date)this.executionStartDate)));
        xml.append("  ").append(XmlHandler.addTagValue((String)"execution_end_date", (String)XmlHandler.date2string((Date)this.executionEndDate)));
        xml.append("  ").append(XmlHandler.addTagValue((String)"logging_string", (String)XmlHandler.buildCDATA((String)this.loggingString)));
        xml.append("  ").append(XmlHandler.addTagValue((String)"first_log_line_nr", (int)this.firstLoggingLineNr));
        xml.append("  ").append(XmlHandler.addTagValue((String)"last_log_line_nr", (int)this.lastLoggingLineNr));
        xml.append("  ").append(XmlHandler.openTag((String)CONST_ACTION_STATUS)).append(Const.CR);
        for (ActionStatus actionStatus : this.actionStatusList) {
            xml.append(actionStatus.getXml()).append(Const.CR);
        }
        xml.append("  ").append(XmlHandler.closeTag((String)CONST_ACTION_STATUS)).append(Const.CR);
        if (this.result != null) {
            String resultXML = sendResultXmlWithStatus ? this.result.getXml() : this.result.getBasicXml();
            xml.append(resultXML);
        }
        xml.append(XmlHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    public HopServerWorkflowStatus(Node workflowStatusNode) throws HopException {
        this();
        Node resultNode;
        this.workflowName = XmlHandler.getTagValue((Node)workflowStatusNode, (String)"workflowname");
        this.id = XmlHandler.getTagValue((Node)workflowStatusNode, (String)"id");
        this.statusDescription = XmlHandler.getTagValue((Node)workflowStatusNode, (String)"status_desc");
        this.errorDescription = XmlHandler.getTagValue((Node)workflowStatusNode, (String)"error_desc");
        this.logDate = XmlHandler.stringToDate((String)XmlHandler.getTagValue((Node)workflowStatusNode, (String)CONST_LOG_DATE));
        this.executionStartDate = XmlHandler.stringToDate((String)XmlHandler.getTagValue((Node)workflowStatusNode, (String)"execution_start_date"));
        this.executionEndDate = XmlHandler.stringToDate((String)XmlHandler.getTagValue((Node)workflowStatusNode, (String)"execution_end_date"));
        this.logDate = XmlHandler.stringToDate((String)XmlHandler.getTagValue((Node)workflowStatusNode, (String)CONST_LOG_DATE));
        this.firstLoggingLineNr = Const.toInt((String)XmlHandler.getTagValue((Node)workflowStatusNode, (String)"first_log_line_nr"), (int)0);
        this.lastLoggingLineNr = Const.toInt((String)XmlHandler.getTagValue((Node)workflowStatusNode, (String)"last_log_line_nr"), (int)0);
        Node statusListNode = XmlHandler.getSubNode((Node)workflowStatusNode, (String)CONST_ACTION_STATUS);
        int nr = XmlHandler.countNodes((Node)statusListNode, (String)"action_status");
        for (int i = 0; i < nr; ++i) {
            Node actionStatusNode = XmlHandler.getSubNodeByNr((Node)statusListNode, (String)"action_status", (int)i);
            ActionStatus actionStatus = new ActionStatus(actionStatusNode);
            this.actionStatusList.add(actionStatus);
        }
        String loggingString64 = XmlHandler.getTagValue((Node)workflowStatusNode, (String)"logging_string");
        if (!Utils.isEmpty((CharSequence)loggingString64)) {
            String dataString64 = loggingString64.substring("<![CDATA[".length(), loggingString64.length() - "]]>".length());
            try {
                this.loggingString = HttpUtil.decodeBase64ZippedString((String)dataString64);
            }
            catch (IOException e) {
                this.loggingString = "Unable to decode logging from remote server : " + String.valueOf(e) + Const.CR + Const.getSimpleStackTrace((Throwable)e) + Const.CR + Const.getStackTracker((Throwable)e);
            }
        } else {
            this.loggingString = "";
        }
        if ((resultNode = XmlHandler.getSubNode((Node)workflowStatusNode, (String)"result")) != null) {
            try {
                this.result = new Result(resultNode);
            }
            catch (HopException e) {
                this.loggingString = this.loggingString + "Unable to serialize result object as XML" + Const.CR + Const.getSimpleStackTrace((Throwable)e) + Const.CR + Const.getStackTracker((Throwable)e) + Const.CR;
            }
        }
    }

    public static HopServerWorkflowStatus fromXml(String xml) throws HopException {
        Document document = XmlHandler.loadXmlString((String)xml);
        return new HopServerWorkflowStatus(XmlHandler.getSubNode((Node)document, (String)XML_TAG));
    }

    public boolean isRunning() {
        if (this.getStatusDescription() == null) {
            return false;
        }
        return this.getStatusDescription().equalsIgnoreCase("Running") || this.getStatusDescription().equalsIgnoreCase("Initializing");
    }

    public boolean isWaiting() {
        if (this.getStatusDescription() == null) {
            return false;
        }
        return this.getStatusDescription().equalsIgnoreCase("Waiting");
    }

    public boolean isFinished() {
        if (this.getStatusDescription() == null) {
            return false;
        }
        return this.getStatusDescription().equalsIgnoreCase("Finished") || this.getStatusDescription().equalsIgnoreCase("Finished (with errors)");
    }

    public boolean isStopped() {
        if (this.getStatusDescription() == null) {
            return false;
        }
        return this.getStatusDescription().equalsIgnoreCase("Stopped") || this.getStatusDescription().equalsIgnoreCase("Stopped (with errors)");
    }

    @Generated
    public String getWorkflowName() {
        return this.workflowName;
    }

    @Generated
    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public String getStatusDescription() {
        return this.statusDescription;
    }

    @Generated
    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    @Generated
    public String getErrorDescription() {
        return this.errorDescription;
    }

    @Generated
    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    @Generated
    public String getLoggingString() {
        return this.loggingString;
    }

    @Generated
    public void setLoggingString(String loggingString) {
        this.loggingString = loggingString;
    }

    @Generated
    public int getFirstLoggingLineNr() {
        return this.firstLoggingLineNr;
    }

    @Generated
    public void setFirstLoggingLineNr(int firstLoggingLineNr) {
        this.firstLoggingLineNr = firstLoggingLineNr;
    }

    @Generated
    public int getLastLoggingLineNr() {
        return this.lastLoggingLineNr;
    }

    @Generated
    public void setLastLoggingLineNr(int lastLoggingLineNr) {
        this.lastLoggingLineNr = lastLoggingLineNr;
    }

    @Generated
    public List<ActionStatus> getActionStatusList() {
        return this.actionStatusList;
    }

    @Generated
    public void setActionStatusList(List<ActionStatus> actionStatusList) {
        this.actionStatusList = actionStatusList;
    }

    @Generated
    public Result getResult() {
        return this.result;
    }

    @Generated
    public void setResult(Result result) {
        this.result = result;
    }

    @Generated
    public Date getLogDate() {
        return this.logDate;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    @Generated
    public void setLogDate(Date logDate) {
        this.logDate = logDate;
    }

    @Generated
    public Date getExecutionStartDate() {
        return this.executionStartDate;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    @Generated
    public void setExecutionStartDate(Date executionStartDate) {
        this.executionStartDate = executionStartDate;
    }

    @Generated
    public Date getExecutionEndDate() {
        return this.executionEndDate;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    @Generated
    public void setExecutionEndDate(Date executionEndDate) {
        this.executionEndDate = executionEndDate;
    }
}

