/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.util.prefs.Preferences;
import org.apache.hop.core.util.IPluginProperty;
import org.apache.hop.core.util.KeyValue;
import org.apache.hop.core.xml.XmlHandler;
import org.w3c.dom.Node;

public class IntegerPluginProperty
extends KeyValue<Integer>
implements IPluginProperty {
    private static final long serialVersionUID = -2990345692552430357L;

    public IntegerPluginProperty(String key) throws IllegalArgumentException {
        super(key, DEFAULT_INTEGER_VALUE);
    }

    @Override
    public boolean evaluate() {
        Integer value = (Integer)this.getValue();
        return value != null && value != 0;
    }

    @Override
    public void appendXml(StringBuilder builder) {
        builder.append(XmlHandler.addTagValue((String)this.getKey(), (int)((Integer)this.getValue())));
    }

    @Override
    public void loadXml(Node node) {
        Integer value = Integer.parseInt(XmlHandler.getTagValue((Node)node, (String)this.getKey()));
        this.setValue(value);
    }

    @Override
    public void saveToPreferences(Preferences node) {
        node.putInt(this.getKey(), (Integer)this.getValue());
    }

    @Override
    public void readFromPreferences(Preferences node) {
        this.setValue(node.getInt(this.getKey(), (Integer)this.getValue()));
    }
}

