/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.delegates;

import java.util.List;
import org.apache.hop.base.AbstractMeta;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.gui.IUndo;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.dialog.NotePadDialog;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;

public class HopGuiNotePadDelegate {
    private static final Class<?> PKG = HopGui.class;
    private HopGui hopGui;
    private IHopFileTypeHandler handler;
    private PropsUi props;

    public HopGuiNotePadDelegate(HopGui hopGui, IHopFileTypeHandler handler) {
        this.hopGui = hopGui;
        this.handler = handler;
        this.props = PropsUi.getInstance();
    }

    public void deleteNotes(AbstractMeta meta, List<NotePadMeta> notes) {
        if (Utils.isEmpty(notes)) {
            return;
        }
        int[] idxs = new int[notes.size()];
        Object[] noteCopies = new NotePadMeta[notes.size()];
        for (int i = 0; i < idxs.length; ++i) {
            idxs[i] = meta.indexOfNote(notes.get(i));
            noteCopies[i] = new NotePadMeta(notes.get(i));
        }
        for (NotePadMeta notePadMeta : notes) {
            int idx = meta.indexOfNote(notePadMeta);
            meta.removeNote(idx);
        }
        this.hopGui.undoDelegate.addUndoDelete((IUndo)meta, noteCopies, idxs);
        this.handler.updateGui();
    }

    public void deleteNote(AbstractMeta meta, NotePadMeta notePadMeta) {
        int idx = meta.indexOfNote(notePadMeta);
        if (idx >= 0) {
            meta.removeNote(idx);
            this.hopGui.undoDelegate.addUndoDelete((IUndo)meta, new NotePadMeta[]{notePadMeta.clone()}, new int[]{idx});
        }
        this.handler.updateGui();
    }

    public void newNote(IVariables variables, AbstractMeta meta, int x, int y) {
        String title = BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.NoteEditor.Title", (String[])new String[0]);
        NotePadDialog dialog = new NotePadDialog(variables, this.hopGui.getShell(), title);
        NotePadMeta note = dialog.open();
        if (note != null) {
            NotePadMeta newNote = new NotePadMeta(note.getNote(), x, y, 20, 20, note.getFontName(), note.getFontSize(), note.isFontBold(), note.isFontItalic(), note.getFontColorRed(), note.getFontColorGreen(), note.getFontColorBlue(), note.getBackGroundColorRed(), note.getBackGroundColorGreen(), note.getBackGroundColorBlue(), note.getBorderColorRed(), note.getBorderColorGreen(), note.getBorderColorBlue());
            meta.addNote(newNote);
            this.hopGui.undoDelegate.addUndoNew((IUndo)meta, new NotePadMeta[]{newNote}, new int[]{meta.indexOfNote(newNote)});
            this.handler.updateGui();
        }
    }
}

