/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.beam.model.expansion.v1.ExpansionServiceGrpc;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.sdk.util.construction.ExpansionServiceClient;
import org.apache.beam.sdk.util.construction.ExpansionServiceClientFactory;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.Channel;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.ManagedChannel;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DefaultExpansionServiceClientFactory
implements ExpansionServiceClientFactory {
    private @UnknownKeyFor @NonNull @Initialized Map< @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor, @UnknownKeyFor @NonNull @Initialized ExpansionServiceClient> expansionServiceMap = new ConcurrentHashMap<Endpoints.ApiServiceDescriptor, ExpansionServiceClient>();
    private @UnknownKeyFor @NonNull @Initialized Function< @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor, @UnknownKeyFor @NonNull @Initialized ManagedChannel> channelFactory;

    private DefaultExpansionServiceClientFactory(@UnknownKeyFor @NonNull @Initialized Function< @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor, @UnknownKeyFor @NonNull @Initialized ManagedChannel> channelFactory) {
        this.channelFactory = channelFactory;
    }

    public static @UnknownKeyFor @NonNull @Initialized DefaultExpansionServiceClientFactory create(@UnknownKeyFor @NonNull @Initialized Function< @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor, @UnknownKeyFor @NonNull @Initialized ManagedChannel> channelFactory) {
        return new DefaultExpansionServiceClientFactory(channelFactory);
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
        for (ExpansionServiceClient client : this.expansionServiceMap.values()) {
            ExpansionServiceClient closer = client;
            if (closer == null) continue;
            closer.close();
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ExpansionServiceClient getExpansionServiceClient(final  @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor endpoint) {
        return this.expansionServiceMap.computeIfAbsent(endpoint, e -> new ExpansionServiceClient(){
            private final @UnknownKeyFor @NonNull @Initialized ManagedChannel channel;
            private final // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized ExpansionServiceGrpc.ExpansionServiceBlockingStub service;
            {
                this.channel = (ManagedChannel)DefaultExpansionServiceClientFactory.this.channelFactory.apply(endpoint);
                this.service = ExpansionServiceGrpc.newBlockingStub((Channel)this.channel);
            }

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ExpansionApi.ExpansionResponse expand(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ExpansionApi.ExpansionRequest request) {
                return this.service.expand(request);
            }

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ExpansionApi.DiscoverSchemaTransformResponse discover(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ExpansionApi.DiscoverSchemaTransformRequest request) {
                return this.service.discoverSchemaTransform(request);
            }

            @Override
            public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.channel.shutdown();
            }
        });
    }
}

