/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDLobLocator;
import com.ibm.as400.access.SQLLocator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

abstract class SQLLocatorBase
implements SQLLocator {
    SQLLocatorBase() {
    }

    @Override
    public abstract Object clone();

    static byte[] readInputStream(InputStream stream, int length, JDLobLocator locator, boolean doubleByteOffset) throws SQLException {
        ByteArrayOutputStream baos = length > 256 && length < 0x100000 ? new ByteArrayOutputStream(length) : (length >= 0x100000 ? new ByteArrayOutputStream(0x100000) : new ByteArrayOutputStream());
        int blockSize = length <= 0 || length >= 1000000 ? 1000000 : length;
        byte[] byteBuffer = new byte[blockSize];
        try {
            int totalBytesRead = 0;
            int bytesRead = stream.read(byteBuffer, 0, blockSize);
            while (bytesRead > -1 && (totalBytesRead < length || length < 0)) {
                int bytesRemaining;
                baos.write(byteBuffer, 0, bytesRead);
                if (locator != null) {
                    if (doubleByteOffset) {
                        locator.writeData(totalBytesRead / 2, byteBuffer, 0, bytesRead, true);
                    } else {
                        locator.writeData(totalBytesRead, byteBuffer, 0, bytesRead, true);
                    }
                }
                if (length > 0 && (bytesRemaining = length - (totalBytesRead += bytesRead)) < blockSize) {
                    blockSize = bytesRemaining;
                }
                bytesRead = stream.read(byteBuffer, 0, blockSize);
            }
        }
        catch (IOException ie) {
            JDError.throwSQLException("HY000", ie);
        }
        byte[] returnArray = baos.toByteArray();
        baos.reset();
        return returnArray;
    }
}

