/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hop.pipeline.transforms.mongodbinput;

import org.apache.hop.core.injection.BaseMetadataInjectionTestJunit5;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILogChannelFactory;
import org.apache.hop.pipeline.transforms.mongodboutput.MongoDbOutputMetaInjectionTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

/** MDI test for MongoDbInput. */
class MongoDbInputMetaInjectionTest extends BaseMetadataInjectionTestJunit5<MongoDbInputMeta> {

  private ILogChannelFactory oldLogChannelInterfaceFactory;

  @BeforeEach
  void setup() throws Exception {
    oldLogChannelInterfaceFactory = HopLogStore.getLogChannelFactory();
    MongoDbOutputMetaInjectionTest.setHopLogFactoryWithMock();
    setup(new MongoDbInputMeta());
  }

  @AfterEach
  void tearDown() {
    HopLogStore.setLogChannelFactory(oldLogChannelInterfaceFactory);
  }

  @Test
  void test() throws Exception {
    check("CONNECTION", () -> meta.getConnectionName());
    check("JSON_FIELD", () -> meta.getJsonField());
    check("JSON_QUERY", () -> meta.getJsonQuery());
    check("COLLECTION", () -> meta.getCollection());
    check("JSON_OUTPUT_FIELD", () -> meta.getJsonFieldName());
    check("AGG_PIPELINE", () -> meta.isAggPipeline());
    check("OUTPUT_JSON", () -> meta.isOutputJson());
    check("EXECUTE_FOR_EACH_ROW", () -> meta.isExecuteForEachIncomingRow());
    check("FIELD_NAME", () -> meta.getFields().get(0).fieldName);
    check("FIELD_PATH", () -> meta.getFields().get(0).fieldPath);
    check("FIELD_TYPE", () -> meta.getFields().get(0).hopType);
  }
}
