/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.exception;

import org.apache.hop.core.Const;

public class HopException
extends Exception {
    private static final long serialVersionUID = -2260895195255402040L;

    public HopException() {
    }

    public HopException(String message) {
        super(message);
    }

    public HopException(Throwable cause) {
        super(cause);
    }

    public HopException(String message, Throwable cause) {
        super(message, cause);
    }

    @Override
    public String getMessage() {
        StringBuilder retval = new StringBuilder();
        retval.append(Const.CR);
        retval.append(super.getMessage()).append(Const.CR);
        Throwable cause = this.getCause();
        if (cause != null) {
            String message = cause.getMessage();
            if (message != null) {
                retval.append(message).append(Const.CR);
            } else {
                StackTraceElement[] ste = cause.getStackTrace();
                for (int i = ste.length - 1; i >= 0; --i) {
                    retval.append(" at ").append(ste[i].getClassName()).append(".").append(ste[i].getMethodName()).append(" (").append(ste[i].getFileName()).append(":").append(ste[i].getLineNumber()).append(")").append(Const.CR);
                }
            }
        }
        return retval.toString();
    }

    public String getSuperMessage() {
        return super.getMessage();
    }
}

